"""
"""

from overrides import overrides
from typing import (
    List,
    Union,
    Dict,
    Text,
    Any
)
from .base_template import BaseTemplate


class EntityRewriteTemplate(BaseTemplate):
    """ """
    def __init__(self):
        super().__init__()
        self._examples = [
            {
                "claim": "Sam is sleeping.",
                "topical_entity": "Sam",
                "expected_answer": "PersonX is sleeping."
            },
            {
                "claim": "After completing his education, Fatehabadi worked as a researcher.",
                "topical_entity": "Zia Fatehabadi",
                "expected_answer": "After completing his education, PersonX worked as a researcher."
            },
            {
                "claim": "He was born in 1987.",
                "topical_entity": "Zia Fatehabadi",
                "expected_answer": "PersonX was born in 1987."
            },
            {
                "claim": "The family business was focused on construction.",
                "topical_entity": "Adam Delimkhanov",
                "expected_answer": "The family business was focused on construction."
            }
        ]
        
    @overrides
    def get_prompt_template(self, **kwargs) -> Union[List[Dict[Text, Any]], Text]:
        """
        """
        
        user_template = (
            "You'll be given a claim and a topical entity. Please rewrite the claim so that all references"
            " to the topical entity are replaced with a anonymized placeholder `PersonX`.\n\n"
            "If you are not sure about whether a pronoun or alias refers to the topical entity and it is the only "
            "potential reference to the topical entity in the claim, replace it with `PersonX` as well."
            "Generate the claim without any additional information or context.\n\n"
            "**Claim**: {claim}\n\n"
            "**Topical Entity**: {topical_entity}\n\n"
        )

        agent_template = (
            "{expected_answer}"
        )

        response = []
        
        for example in self._examples:
            response.append({
                "role": "user",
                "content": user_template.format(**example)
            })
            response.append({
                "role": "assistant",
                "content": agent_template.format(**example)
            })
            
        response.append({
            "role": "user",
            "content": user_template.format(**kwargs)
        })
        
        return response
    
    @overrides
    def get_completion_template(self, **kwargs) -> Union[List[Dict[Text, Any]], Text]:
        """ """
        
        agent_template = (
            "{expected_answer}"
        )
        
        return [{
            "role": "assistant",
            "content": "" if kwargs.get("is_completion") else agent_template.format(**kwargs)
        }]