""" """

from registrable import Registrable
from abc import ABC, abstractmethod
from typing import (
    List,
    Dict,
    Any,
    Text
)


class BaseClusterRunner(Registrable, ABC):
    """ """
    def __init__(
        self,
        targets: List[int]
    ):
        self._targets = sorted(targets, reverse=False)
        
    @abstractmethod
    def run(self, inputs: List[List[Dict[Text, Any]]]) -> List[List[Dict[Text, Any]]]:
        """ """
        raise NotImplementedError