""" """

from functools import lru_cache
from typing import (
    Text, List, Union, Optional,
    Iterable, Generator
)
try:
    import ujson as json
except ImportError:
    import json
import re
from dataclasses import dataclass, field


@dataclass(eq=True)
class NQInstance:
    index: int
    topic: Text
    answer_type: Text
    question: Text
    answer: Text

    
class NQDataReader:
    def __init__(self, data_path: Union[List[Text], Text]):
        if not isinstance(data_path, List):
            data_path = [data_path]
            
        self._data_paths = data_path
        
    @lru_cache(maxsize=3)
    def _read_file(self, file_path: Text) -> List[NQInstance]:
        data_list = []
        with open(file_path, "r", encoding='utf-8') as file_:
            for line in file_:
                data_list.append(NQInstance(
                    **json.loads(line)
                ))
                
        return data_list
    
    def __iter__(self) -> Iterable[NQInstance]:
        for file_path in self._data_paths:
            for item in self._read_file(file_path):
                yield item