""" """

from functools import lru_cache
from typing import (
    Text, List, Union, Optional,
    Iterable, Generator
)
import ujson as json
from dataclasses import dataclass, field


@dataclass(frozen=True, eq=True)
class UniqueAnswerClusterItem:
    topic: Text
    question: Text
    back_ref_id: int  # Notice that back_ref_id is the one ref back to last time
    answer_template: Text
    filtered_answers: List[Text]
    clusters: List[Text]


class UniqueAnswerClusterDataReader:
    def __init__(self, data_path: Union[List[Text], Text]):
        if not isinstance(data_path, List):
            data_path = [data_path]
            
        self._data_paths = data_path

    def _parse_item(self, line_text: Text) -> UniqueAnswerClusterItem:
        line_dict = json.loads(line_text)
        line_dict.pop("messages")
        # print(line_dict)
        return UniqueAnswerClusterItem(**line_dict)
    
    def _read_file(self, file_path: Text) -> List[UniqueAnswerClusterItem]:
        with open(file_path, "r", encoding='utf-8') as file_:
            return [self._parse_item(line) for line in file_]
        
    def __iter__(self) -> Iterable[UniqueAnswerClusterItem]:
        for file_path in self._data_paths:
            for item in self._read_file(file_path):
                yield item