""" """


from functools import lru_cache
from typing import (
    Text, List, Union, Optional,
    Iterable, Generator
)
import ujson as json
from dataclasses import dataclass, field


@dataclass
class ClaimExtraction:
    generation: Text
    topic: Text
    tag: Text
    claims: List[Text]


class VerifiableClaimsDataReader:
    def __init__(self, data_path: Union[List[Text], Text]):
        if not isinstance(data_path, List):
            data_path = [data_path]

        self._data_paths = data_path

    def _parse_item(self, line_text: Text) -> ClaimExtraction:
        """ """
        item = json.loads(line_text)
        return ClaimExtraction(
            generation=item["response"],
            tag=item["prompt_source"],
            claims=item["all_claims"]
        )
        
    @lru_cache(maxsize=3)
    def _read_file(self, file_path: Text) -> List[ClaimExtraction]:
        with open(file_path, "r", encoding='utf-8') as file_:
            return [self._parse_item(line) for line in file_]
        
    def __iter__(self) -> Iterable[ClaimExtraction]:
        for file_path in self._data_paths:
            for item in self._read_file(file_path):
                yield item