""" """

from dataclasses import dataclass
from overrides import overrides
from typing import Union, Text, List, Dict, Optional, Callable, Any

from langchain_core.runnables.config import RunnableConfig
from langchain_core.runnables.base import Runnable
from langchain.prompts import (
    ChatPromptTemplate,
    FewShotChatMessagePromptTemplate,
)
from langchain_core.output_parsers import BaseOutputParser
import re

# TODO: use customer downloaded examples for example selector
from langchain_interface.example_selectors import ConstantExampleSelector, ExampleSelector
from langchain_interface.steps import Step, FewShotStep
from langchain_interface.instances.instance import LLMResponse


class FactualResponseOnTopicOutputParser(BaseOutputParser[LLMResponse]):
        
    @overrides
    def parse(self, text: Text) -> LLMResponse:
        """ """
        return LLMResponse(
            messages=text.strip(),
        )
    
    @property
    def _type(self) -> Text:
        return "factual-response-on-topic"


class FactualResponseOnTopicStep(Step):
    
    @overrides
    def get_prompt_template(self) -> Runnable:
        """ """
        
        return ChatPromptTemplate.from_messages(
            [
                (
                    "human", (
                        "Tell me a bio of {topic}."
                    )
                ),
            ]
        )
        
    @overrides
    def get_output_parser(self) -> BaseOutputParser:
        """ """
        
        return FactualResponseOnTopicOutputParser()