"""
"""

import click
import ujson as json
import os
import torch
from src.base_declaritivizer import (
    get_declarativizer_model,
    declarativize,
)


@click.command()
@click.option("--input-file-path", type=click.Path(exists=True), help="Path to the input file.", required=True)
@click.option("--output-file-path", type=click.Path(exists=False), help="Path to the output file.", required=True)
def main(
    input_file_path,
    output_file_path
):
    """
    """
    
    with open(input_file_path, 'r', encoding='utf-8') as file_:
        data = [json.loads(line) for line in file_]
        
    model, tokenizer = get_declarativizer_model()
    model.eval()
    
    # This is relatively small, so we can do it in one gpu
    device = torch.device("cuda:0")
    model.to(device)
    processed = declarativize(data, model, tokenizer, device)
    
    os.makedirs(os.path.dirname(output_file_path), exist_ok=True)
    with open(output_file_path, 'w', encoding='utf-8') as file_:
        for item in processed:
            file_.write(json.dumps(item) + '\n')
            
            
if __name__ == '__main__':
    main()