""" Convert FActScore data format into VeriScore data format. """

import click
import ujson as json
import os


@click.command()
@click.option("--input-path", type=click.Path(exists=True), help="Path to the input file.")
@click.option("--output-path", type=click.Path(exists=False), help="Path to the output file.")
def main(
    input_path,
    output_path
):
    """ """
    
    with open(input_path, 'r', encoding='utf-8') as file_:
        with open(output_path, 'w', encoding='utf-8') as output_file:
            for line in file_:
                item = json.loads(line)
                output_file.write(json.dumps({
                    "response": item["output"],
                    "prompt_source": "FActScore",
                    "model": os.path.basename(input_path).split('.')[0],
                }) + '\n')

                
if __name__ == "__main__":
    main()