"""For a given question, provide a completely bleached answer.
"""

from overrides import overrides
from typing import (
    List,
    Union,
    Dict,
    Text,
    Any
)
from .base_template import BaseTemplate


class BleachedAnswerTemplate(BaseTemplate):
    """ """
    def __init__(self):
        super().__init__()
        self._examples = [
            {
                "question": "Who was the first President of the Supreme Court of Bolivia?",
                "answer": "It is a person.",
            },
            {
                "question": "What is the capital of France?",
                "answer": "It is a city.",
            },
            {
                "question": "When was the album \"When the Sun Goes Down\" by Selena Gomez released in Japan (specific day, month, and year)?",
                "answer": "It is a date.",
            },
            {
                "question": "What did Alison Garrs overdose on in the last episode of Season 2 of Happy Valley?",
                "answer": "It is a substance.",
            },
            {
                "question": "What certification did Alan Walker's album, \"Different World,\" receive in the region of Singapore?",
                "answer": "It is a certification.",
            },
            {
                "question": "In which season and episode of Archer is Cheryl revealed to be a millionaire?",
                "answer": "It is a season and episode.",
            },
        ]
        
    @overrides
    def get_prompt_template(self, **kwargs) -> Union[List[Dict[Text, Any]], Text]:
        """
        """
        
        user_template = (
            "You'll be given a question. Please provide a completely bleached answer without any additional information or context"
            " other than those that can be trivially inferred from the question.\n\n"
            "You should generate the bleached answer without any additional information or context.\n\n"
            "**Question**: {question}\n\n"
        )
        
        agent_template = (
            "{answer}"
        )

        response = []
        
        for example in self._examples:
            response.append({
                "role": "user",
                "content": user_template.format(**example)
            })
            response.append({
                "role": "assistant",
                "content": agent_template.format(**example)
            })
            
        response.append({
            "role": "user",
            "content": user_template.format(**kwargs)
        })
        
        return response
    
    @overrides
    def get_completion_template(self, **kwargs) -> Union[List[Dict[Text, Any]], Text]:
        """ """
        
        agent_template = (
            "{answer}"
        )
        
        return [{
            "role": "assistant",
            "content": "" if kwargs.get("is_completion") else agent_template.format(**kwargs)
        }]