from unittest import TestCase
from src.base_clustering import test_entailment, get_entailment_model


class TestEntailmentModel(TestCase):
    def setUp(self):
        """
        """
        self._testcases = [
            ("The quick brown fox jumps over the lazy dog", "The quick brown fox jumps over the lazy dog"),
            ("Paris is the capital of France.", "The capital of France is Paris."),
            ("Theory of relativity was proposed in 1905 by Albert Einstein.", "Albert Einstein proposed the theory of relativity in the early 20th century."),
            ("A boy hits a ball, with a bat.", "The kid is playing in a baseball game.")
        ]
    
    def test_predict(self):
        """
        """
        tokenizer, entailment_model = get_entailment_model()
        self.assertListEqual(test_entailment(self._testcases, entailment_model, tokenizer), [True, True, True, False])