import torch.nn as nn
import torch.nn.functional as F


class SampleNet(nn.Module):

    def __init__(self):
        super(SampleNet, self).__init__()
        self.fc1 = nn.Linear(32, 16, bias=False)  # 6*6 from image dimension
        self.fc2 = nn.Linear(16, 8, bias=False)
        self.fc3 = nn.Linear(8, 5, bias=False)

    def forward(self, x):

        x = x.view(-1, 32)
        x = F.relu(self.fc1(x))
        x = F.relu(self.fc2(x))
        x = self.fc3(x)
        return x


class SampleNetCommon(nn.Module):

    def __init__(self, fc1: nn.Module):
        super(SampleNetCommon, self).__init__()
        self.fc1 = fc1
        self.fc2 = nn.Linear(16, 8, bias=False)
        self.fc3 = nn.Linear(8, 5, bias=False)

    def forward(self, x):

        x = x.view(-1, 32)
        x = F.relu(self.fc1(x))
        x = F.relu(self.fc2(x))
        x = self.fc3(x)
        return x
