import io
from typing import Optional, Sequence, Any, Callable, BinaryIO, Union

import matplotlib.pyplot as plt
import pandas as pd
import seaborn as sns


def plot_confusion_matrix(confusion_matrix,
                          consumers: Union[Callable[[BinaryIO], Any], Sequence[Callable[[BinaryIO], Any]]],
                          title: Optional[str] = None, cmap: Optional[Any] = None):
    df_cm = pd.DataFrame(confusion_matrix)
    df_cm.index.name = 'Actual'
    df_cm.columns.name = 'Predicted'
    sns.set(font_scale=1.4)  # for label size
    ax = sns.heatmap(df_cm, annot=False, annot_kws={"size": 16}, cmap=cmap)  # font size
    if title is not None:
        ax.set_title(title)
    fig = ax.get_figure()
    buf: BinaryIO = io.BytesIO()
    fig.savefig(buf, format='png')
    for consumer in list(consumers):
        buf.seek(0)
        consumer(buf)
    plt.close(fig)
