from sklearn.manifold import TSNE
from sklearn.decomposition import PCA
import io
import matplotlib
matplotlib.use('Agg')
import matplotlib.pyplot as plt
import seaborn as sns


class T_SNE:
    def __init__(self, n_dimensions=2):
        self.n_dim = n_dimensions
        self.tsne = TSNE(n_components=n_dimensions, perplexity=40, n_iter=500, init='random', verbose=1)

    @staticmethod
    def _dim_reduction(data, n_dim=50):
        pca = PCA(n_components=n_dim)
        return pca.fit_transform(data)

    def calculate_tsne(self, data):
        red_data = self._dim_reduction(data)
        return self.tsne.fit_transform(red_data)

    def calculate(self, data, labels, categories):
        data_to_plot = self.calculate_tsne(data)
        print(data_to_plot.shape)
        asd = {'x': data_to_plot[:, 0], 'y': data_to_plot[:, 1], 'labels': labels, 'category': categories}
        plt.figure(figsize=(16, 10))
        nr_classes = len(set(labels))
        ax = sns.scatterplot(
            x="x", y="y",
            hue="labels",
            style="category",
            palette=sns.color_palette("colorblind", nr_classes),
            data=asd,
            legend='full',
            alpha=1.0,
            markers=["o", "X"]
        )
        fig = ax.get_figure()
        buf = io.BytesIO()
        fig.savefig(buf, format='jpeg')
        buf.seek(0)
        return buf
