import wandb

from dataclasses import dataclass
from .common import *
from .evaluation import evaluate

from pprint import pprint


@dataclass(frozen=True)
class ConfigArgs:
    f : str
    sample_random_times: int
    grad_pen: bool
    noise: bool
    noise_std: float
    lambda_gp: int
    max_clip: float
    num_v_updates: int
    log_loss: bool
    alpha: float
    eval_interval: int
    v_update: str
    clip_threshold: float
    update_Q_inference: bool

def log_wandb(info,args,step):
    if (args.use_wandb):
        wandb.log(info, step=step)
    else:
        pprint(info) 