# python3.7
"""Collects all configs."""

from .eg3d_config import EG3DConfig
from .pigan_config import PiGANConfig
from .volumegan_config import VolumeGANConfig
from .eg3d_random_pose_config import EG3DRandomPoseConfig
from .ablation3d_config import Ablation3DConfig
from .ablation3d_random_pose_config import Ablation3DRandomPoseConfig
from .stylenerf_config import StyleNeRFConfig
from .graf_config import GRAFConfig
from .gram_config import GRAMConfig
from .epigraf_config import EpiGRAFConfig
from .stylesdf_config import StyleSDFConfig


__all__ = ['CONFIG_POOL', 'build_config']

CONFIG_POOL = [
    EG3DConfig,
    PiGANConfig,
    VolumeGANConfig,
    EG3DRandomPoseConfig,
    Ablation3DConfig,
    Ablation3DRandomPoseConfig,
    StyleNeRFConfig,
    GRAFConfig,
    GRAMConfig,
    EpiGRAFConfig,
    StyleSDFConfig,
]


def build_config(invoked_command, kwargs):
    """Builds a configuration based on the invoked command.

    Args:
        invoked_command: The command that is invoked.
        kwargs: Keyword arguments passed from command line, which will be used
            to build the configuration.

    Raises:
        ValueError: If the `invoked_command` is missing.
    """
    for config in CONFIG_POOL:
        if config.name == invoked_command:
            return config(kwargs)
    raise ValueError(f'Invoked command `{invoked_command}` is missing!\n')
