#!/bin/sh


source $LMOD_PKG/init/zsh
source ~/scratch/venv/bin/activate

wandb offline

seed=42

dataset=miniimagenet
test_dataset=null
mode=ntk
ways=5
train_shots=1
test_shots=15
training=1
backbone=cnn4

num_iterations=30000
adaptation_steps=5
meta_lr=0.01
fast_lr=0.1
meta_batch_size=16
kernel_batch_size=32

loss=l2
channel_size=32
t=0.0

tag=null
active_strategy=random
train_active_strategy=random
sweep_name=null
per_class=false
threshold=2.0

checkpoint_path=null
checkpoint_dir=null


# j p v x y
# Parsing arguments
while getopts ":q:j:s:g:m:w:r:e:i:a:l:f:b:k:o:d:h:t:u:n:y:z:p:x:v:" flag; do
  case "${flag}" in
    q) qsub=${OPTARG};;
    j) job=${OPTARG};;
    s) seed=${OPTARG};;
    g) dataset=${OPTARG};;
    m) mode=${OPTARG};;
    w) ways=${OPTARG};;
    r) train_shots=${OPTARG};;
    e) test_shots=${OPTARG};;
    i) num_iterations=${OPTARG};;
    a) adaptation_steps=${OPTARG};;
    l) meta_lr=${OPTARG};;
    f) fast_lr=${OPTARG};;
    b) meta_batch_size=${OPTARG};;
    k) test_dataset=${OPTARG};;
    o) loss=${OPTARG};;
    d) channel_size=${OPTARG};;
    h) backbone=${OPTARG};;
    t) tag=${OPTARG};;
    u) active_strategy=${OPTARG};;
    p) train_active_strategy=${OPTARG};;
    n) sweep_name=${OPTARG};;
    y) checkpoint_dir=${OPTARG};;
    z) checkpoint_path=${OPTARG};;
    x) per_class=${OPTARG};;
    v) threshold=${OPTARG};;
    :)                                         # If expected argument omitted:
        echo "Error: -${OPTARG} requires an argument."
        exit_abnormal;;                          # Exit abnormally.
    *)                                         # If unknown (any other) option:
        exit_abnormal;;                          # Exit abnormally.
  esac
done

wandb disabled
al_strategies=(random entropy margin dpp coreset typiclust prob_cover gmm)
#al_strategies=(prob_cover typiclust gmm)
echo "seed $seed"

for al_strategy in "${al_strategies[@]}"; do
    echo "========Running active learning strategy: ${al_strategy}==========="
    python main.py task.seed=$seed task.dataset=$dataset task.test_dataset=$test_dataset task.ways=$ways task.train_shots=$train_shots task.test_shots=$test_shots task.tag=$tag \
        model.training=false model.mode=$mode model.backbone=$backbone model.channel_size=$channel_size \
        train.num_iterations=$num_iterations train.meta_lr=$meta_lr train.meta_batch_size=$meta_batch_size train.loss=$loss \
        train.adaptation_steps=$adaptation_steps train.fast_lr=$fast_lr train.kernel_batch_size=$kernel_batch_size \
        active.strategy=$al_strategy active.train_strategy=$train_active_strategy active.per_class=$per_class active.threshold=$threshold \
        sweep_name=$sweep_name checkpoint_dir=$checkpoint_dir checkpoint_path=$checkpoint_path save_entropy=true
done
