#!/bin/sh

qsub=false
job=false

dataset=miniimagenet
test_dataset=null
seed=42
ways=5
train_shots=1
test_shots=15
tag=null

mode=ntk
channel_size=32
backbone=cnn4

training=1
num_iterations=60000
meta_lr=0.01
meta_batch_size=4
loss=l2

fast_lr=0.1
adaptation_steps=5
kernel_batch_size=16
ode_time=0.0

active_strategy=random
train_active_strategy=random
sweep_name=null
per_class=false

checkpoint_path=null
checkpoint_dir=null

# j p v x y
# Parsing arguments
while getopts ":q:j:s:g:m:w:r:e:i:a:l:f:b:k:o:d:h:t:u:n:z:p:x:y:" flag; do
  case "${flag}" in
    q) qsub=${OPTARG};;
    j) job=${OPTARG};;
    s) seed=${OPTARG};;
    g) dataset=${OPTARG};;
    m) mode=${OPTARG};;
    w) ways=${OPTARG};;
    r) train_shots=${OPTARG};;
    e) test_shots=${OPTARG};;
    i) num_iterations=${OPTARG};;
    a) adaptation_steps=${OPTARG};;
    l) meta_lr=${OPTARG};;
    f) fast_lr=${OPTARG};;
    b) meta_batch_size=${OPTARG};;
    k) test_dataset=${OPTARG};;
    o) loss=${OPTARG};;
    d) channel_size=${OPTARG};;
    h) backbone=${OPTARG};;
    t) tag=${OPTARG};;
    u) active_strategy=${OPTARG};;
    p) train_active_strategy=${OPTARG};;
    n) sweep_name=${OPTARG};;
    z) checkpoint_path=${OPTARG};;
    y) checkpoint_dir=${OPTARG};;
    x) per_class=${OPTARG};;
    :)                                         # If expected argument omitted:
        echo "Error: -${OPTARG} requires an argument."
        exit_abnormal;;                          # Exit abnormally.
    *)                                         # If unknown (any other) option:
        exit_abnormal;;                          # Exit abnormally.
  esac
done

command="
    -s $seed -g $dataset -w $ways -r $train_shots -e $test_shots -t $tag \
    -m $mode -d $channel_size -h $backbone \
    -i $num_iterations -l $meta_lr -b $meta_batch_size -o $loss \
    -a $adaptation_steps -f $fast_lr -k $test_dataset \
    -u $active_strategy -p $train_active_strategy -n $sweep_name \
    -z $checkpoint_path -y $checkpoint_dir -x $per_class"

echo "command:" $command

if $job
then
    if $qsub
    then
        sbatch scripts/template_qusb.sh $command
    else
        sbatch scripts/template.sh $command
    fi
else
    if $qsub
    then
        bash scripts/template_qusb.sh $command
    else
        bash scripts/template.sh $command
    fi
fi

