# README

## Overview

This repository contains all scripts for re-producing the results of the BAPO paper.

---

### `bapo_experiments.py`

This is the main script for all experiments.

#### Overview:
- **Experiment Classes**: Each experiment is implemented as a class inheriting from the `Experiment` base class.
- **generate_data()**: Generates synthetic datasets for testing.

#### Usage:
1. Set the `OPENAI_API_KEY`, `ANTHROPIC_API_KEY`, and `GOOGLE_API_KEY` environment variables, e.g.,
    ```bash
    export OPENAI_API_KEY=<your_openai_api_key>
    export ANTHROPIC_API_KEY=<your_anthropic_api_key>
    export GOOGLE_API_KEY=<your_google_api_key>
    ```
2. Run all experiments:
   ```bash
   python bapo_experiments.py
   ```

---

### `plot_results.py`

Generates all plots for the paper using the `plotly` library.

#### Usage:
1. Run `bapo_experiments.py` to generate results.
2. Generate plots:
   ```bash
   python plot_results.py
   ```
---

### `preprocess_space_digest.py`

This script preprocesses a dataset (`space.json`) for use in experiments. It extracts and structures data for tasks like majority review and most negative review experiments.

#### Usage:
1. Download the raw Space digest dataset from [this link](https://github.com/stangelid/qt) as well as the subset from the [ZeroScrolls benchmark](https://huggingface.co/datasets/tau/zero_scrolls/resolve/main/space_digest.zip) benchmark.
2. Place the files in a new directory called `processed_data`.
3. Run the preprocessing script:
   ```bash
   python preprocess_space_digest.py
   ```
---

## Requirements

- Python 3.9+

Install dependencies using:
```bash
pip install -r requirements.txt
```

---

## Project Structure

```
.
├── experiments/
│   ├── bapo_experiments.py
│   ├── plot_results.py
│   ├── preprocess_space_digest.py
├── utils/
│   ├── __init__.py
```

---

## License

This project is licensed under the MIT License. See the `LICENSE` file for details.