# Hyperbolic Associative Memory Networks

Associative memory models have achieved widespread success, but capturing hierarchical structure in data remains difficult when the retrieval process is constrained to Euclidean geometry. In many tasks that require handling hierarchical data, Hopfield networks based on Euclidean representations often struggle to accurately model and retrieve such hierarchical information, easily introducing bias and distortion into semantic relations.
To this end, we extend modern Hopfield retrieval to hyperbolic space. Specifically, we map query and memory vectors from Euclidean space to hyperbolic space via exponential maps, and define an energy function with clear theoretical grounding based on the Minkowski inner product; the retrieval procedure adopts Riemannian manifold optimization, combining curvature-aware gradients with exponential maps to ensure that the optimization trajectory remains on the manifold and yields stable updates.
Our central view can be stated as a hierarchy-sensitivity hypothesis: when the data exhibit clear and deeper hierarchical structure, hyperbolic geometry brings statistically significant improvements; when the hierarchy is weak or only shallow, performance shows no significant difference from Euclidean modern Hopfield networks. We validate this through depth-controlled comparisons and cross-level consistency metrics, and the empirical results are consistent with the hypothesis.
Accordingly, the proposed hyperbolic associative memory can serve as a plug-and-play general memory module embedded into task architectures that require hierarchical understanding, for storing and retrieving raw inputs, intermediate representations, or learned prototypes, and explicitly exploiting hierarchical information.
Moreover, our method is formulated in a model-agnostic manner and applies to any hyperbolic model with constant negative curvature. in this paper, we instantiate it with the Poincaré ball for experiments.


## Environment

- Python: **3.10**
- PyTorch: **2.4.0**
- CUDA: **12.4.1** (use the official PyTorch **cu121** wheels, which are compatible with CUDA 12.x)
- OS: Linux / Windows / macOS (GPU acceleration requires an NVIDIA driver compatible with CUDA 12.x)

> Note: PyTorch CUDA wheels ship with the CUDA runtime, so you usually don’t need the full CUDA Toolkit installed locally. Just ensure your NVIDIA driver supports CUDA 12.x.

## Quick Start

### 1) Create an environment (conda recommended)
```bash
conda create -n hamn python=3.10 -y
conda activate hamn
# GPU (CUDA 12.x)
pip install --index-url https://download.pytorch.org/whl/cu121 \
  torch==2.4.0 torchvision==0.19.0 torchaudio==2.4.0
pip install -r requirements.txt

