import os
import time
import shutil
import argparse
import json

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--frame_start", type=int, default=95)
    parser.add_argument("--frame_end", type=int, default=115)
    parser.add_argument("--output_path", type=str)
    parser.add_argument("--qp", type=int, default=25)
    parser.add_argument("--level", type=int, default=6)

    args = parser.parse_args()
    
    init_index = args.frame_start
    level = args.level
    group_path = os.path.join(args.output_path, "checkpoint/group_info.json")
    with open(group_path, "r") as f:
        group_info_json = json.load(f)
    group_num = len(group_info_json['frame_index'])

    base_dir = os.path.join(args.output_path, "feature_image")
    save_dir = os.path.join(args.output_path, "feature_video")
    os.makedirs(save_dir, exist_ok=True)
    qps = [args.qp]

    for qp in qps:
        out_dir = os.path.join(save_dir, "png_all_" + str(qp))
        os.makedirs(out_dir, exist_ok=True)

        for group in range(group_num):
            frame_start = group_info_json['frame_index'][group][0]
            frame_end = group_info_json['frame_index'][group][1]
            if frame_end > args.frame_end:
                frame_end = args.frame_end
            group_size = frame_end - frame_start + 1
            start_index = frame_start
            if frame_start > args.frame_end:
                break

            group_path = os.path.join(out_dir, "group" + str(group))
            os.makedirs(group_path, exist_ok=True)

            group_video_path = group_path

            input_group_path = os.path.join(base_dir, "group" + str(group))

            for l in range(level):
                for i in range(0,20):
                    if i in [1,3,5]:
                        os.system(f"ffmpeg -start_number {start_index} -i {input_group_path}/%d_{i}_{l}.png -vframes {group_size} -c:v libx264 -qp 0 -pix_fmt yuvj444p {group_video_path}/{i}_{l}.mp4")
                    elif i in [9, 10, 11,  13, 14, 15,  16, 17, 18, 19] and qp > 22:
                        os.system(f"ffmpeg -start_number {start_index} -i {input_group_path}/%d_{i}_{l}.png -vframes {group_size} -c:v libx264 -qp 22 -pix_fmt yuvj444p {group_video_path}/{i}_{l}.mp4")
                    else:
                        os.system(f"ffmpeg -start_number {start_index} -i {input_group_path}/%d_{i}_{l}.png -vframes {group_size} -c:v libx264 -qp {qp} -pix_fmt yuvj444p {group_video_path}/{i}_{l}.mp4")


    shutil.copy(os.path.join(base_dir, "viewer_min_max.json"), os.path.join(out_dir, "viewer_min_max.json"))
    shutil.copy(os.path.join(base_dir, "group_info.json"), os.path.join(out_dir, "group_info.json"))


    print("finish")
