#!/bin/bash

#SBATCH --job-name=curve # Job name
#SBATCH --gres=gpu:1             # how many gpus would you like to use (here I use 1)
#SBATCH --nodes=1                    # Run all processes on a single node
#SBATCH --ntasks=1                   # Run a single task
#SBATCH --cpus-per-task=4            # Number of CPU cores per task
#SBATCH --mem=16G                  # Job memory request
#SBATCH --time=48:00:00              # Time limit hrs:min:sec
#SBATCH --partition=ava_m.p          # partition name
#SBATCH --output=logs/job_%j.log   # output log
#SBATCH --array=0-5



SEED=$((SLURM_ARRAY_TASK_ID + 100))


BMP="./synth-exps/run-${SLURM_ARRAY_TASK_ID}/"
echo $BMP

~/anaconda3/envs/my_laplace/bin/python ./train_1d.py \
    --train_seed $SEED \
    --data_seed 1000 \
    --act_func leakyrelu \
    --prec_act_func softplus \
    --epochs 60 \
    --mean_warmup 25 \
    --total_iters 5 \
    --hidden_layers 3 \
    --hidden_size 128 \
    --clip 1000. \
    --dataset curve \
    --samp_size 128 \
    --step_size_up 5 \
    --cycle_mode triangular2 \
    --diag \
    --base_model_path $BMP
