#!/usr/bin/env python
# coding: utf-8

# In[12]:


import numpy as np
from scipy.optimize import minimize,NonlinearConstraint
from diffprivlib.models import KMeans
from sklearn.model_selection import KFold


# In[22]:


#loss func
def ls_loss(w,x,y):
    if len(x.shape)==1:
        x=x.reshape((1,len(x)))
    n,_=x.shape
    if len(y.shape)>1:
        y=np.reshape(y,n)
    return np.sum((y-np.matmul(x,w))**2)/n
def ls_grad(w,x,y):
    if len(x.shape)==1:
        x=x.reshape((1,len(x)))
    n,_=x.shape
    if len(y.shape)>1:
        y=np.reshape(y,n)
    return -2*np.matmul(np.transpose(x),(y-np.matmul(x,w)))/n
def ls_Lip_bound(w_size,y_size):
    return y_size+w_size
def ls_Hess_bound(w_size,y_size):
    return 1
def logi_loss(w,x,y):
    if len(x.shape)==1:
        x=x.reshape((1,len(x)))
    n,m=x.shape
    if len(y.shape)>1:
        y=np.reshape(y,n)
    if len(w.shape)>1:
        w=np.reshape(w,m)
    z=np.multiply(y,np.matmul(x,w))
    if len(z.shape)>1:
        print('shape err')
    return np.sum(np.log(1+np.exp(-z)))/n
def logi_grad(w,x,y):
    if len(x.shape)==1:
        x=x.reshape((1,len(x)))
    n,m=x.shape
    if len(y.shape)>1:
        y=np.reshape(y,n)
    if len(w.shape)>1:
        w=np.reshape(w,m)
    z=np.multiply(y,np.matmul(x,w))
    if len(z.shape)>1:
        print('shape err')
    return -np.matmul(np.transpose(x),np.multiply(y,1/(1+np.exp(z))))/n
def logi_Lip_bound(w_size,y_size):
    return y_size
def logi_Hess_bound(w_size,y_size):
    return 0.5*y_size*y_size


# huber SVM
def huber_loss(w,x,y,h=0.5):
    n,m=x.shape
    if len(y.shape)>1:
        y=np.reshape(y,n)
    if len(w.shape)>1:
        w=np.reshape(w,m)
    z=np.multiply(y,np.matmul(x,w))
    loss=np.zeros(n)
    idx1=z<1-h
    idx2=np.abs(1-z)<h
    loss[idx1]=1-z[idx1]
    loss[idx2]=((1+h-z[idx2])**2)/(4*h)

    return np.sum(loss)/n
def huber_grad(w,x,y,h=0.5):
    n,m=x.shape
    if len(y.shape)>1:
        y=np.reshape(y,n)
    if len(w.shape)>1:
        w=np.reshape(w,m)
    z=np.multiply(y,np.matmul(x,w))
    idx1=z<1-h
    idx2=np.abs(1-z)<h
    grad1=-np.einsum('i,ij->j',y[idx1],x[idx1,:])
    grad2=-np.einsum('i,ij->j',np.multiply((1+h-z[idx2])/(2*h),y[idx2]),x[idx2,:])
    return (grad1+grad2)/n
def huber_Lip_bound(w_size,y_size):
    return y_size
def huber_Hess_bound(w_size,y_size,h=0.5):
    return y_size*y_size/(2*h)

# DP-learner
def Kifer(x,y,w_size,y_size,loss,grad,Lip_bound,Hess_bound,lamb,privacy_params,w_constraint=False):
    # x is assumed to have l2 norm at most 1
    n,m=x.shape
    if len(y.shape)>1:
        y=np.reshape(y,n)
    epsilon,delta=privacy_params
    L=Lip_bound(w_size,y_size)
    H=Hess_bound(w_size,y_size)
    Delta=H*2/epsilon
    b=np.random.randn(m)*L*2*(1+np.sqrt(2*np.log(1/delta)))/epsilon
    def perturbed_obj(w):
        # loss is averaged loss
        return loss(w,x,y)+(n*lamb+Delta)*np.sum(w**2)/(2*n)+np.dot(b,w)/n
    def grad_perturbed_obj(w):
        return grad(w,x,y)+(n*lamb+Delta)*w/n+b/n
    def w_size_constraint(w):
        return np.sum(w**2)-w_size**2
    if w_constraint:
        constraint=NonlinearConstraint(w_size_constraint,-w_size**2,0)
        res = minimize(perturbed_obj, np.zeros(m),method='SLSQP',jac=grad_perturbed_obj, constraints=constraint)
    else:
        res = minimize(perturbed_obj, np.zeros(m),method='SLSQP',jac=grad_perturbed_obj)
    return res.x


def g_kernel(x,y,rff_sigma):
    # x: n*d, y: m*d
    n=len(x[:,0])
    m=len(y[:,0])
    K=np.exp(
    -np.repeat(np.reshape(np.sum(x**2,1),(n,1)),m,axis=1
                    )/(2*rff_sigma**2)
           -np.repeat(np.reshape(np.sum(y**2,1),(1,m)),n,axis=0
                    )/(2*rff_sigma**2)
           +np.matmul(x,np.transpose(y))/(rff_sigma**2)
          )
    return K
def poly_kernel(d):
    def poly_kernel_eval(x,y):
        return (np.matmul(x,np.transpose(y))/2+0.5)**d
    return poly_kernel_eval
def g_kernel_func(sig):
    def g_kernel_eval(x,y):
        return g_kernel(x,y,sig)
    return g_kernel_eval


# random feature maps
def gaussian_rff_converter(sig,m,d):
    w=np.random.randn(m,d)/sig
    psi=np.random.rand(1,m)*2*np.pi-np.pi
    def gaussian_rff(x):
        n,d=x.shape
        rff=np.cos(np.matmul(x,np.transpose(w))+np.matmul(np.ones((n,1)),psi))/np.sqrt(m)
        return rff
    return gaussian_rff

def DP_subsample_converter(x,kernel,kernel_normalize_constant,m,epsilon):
    n_samples,n_features=x.shape
    landmarks=x[np.random.choice(n_samples, m,replace=False),:]+np.random.laplace(scale=n_features/np.log(1+n_samples*(np.exp(epsilon/2)-1)/m),size=(m,n_features))
    def DP_rf(y):
        m=len(landmarks)
        n,d=y.shape
        Q,D,_=np.linalg.svd(kernel(landmarks,landmarks))
        proj=np.matmul(kernel(y,landmarks),np.einsum('ij,j->ij',Q,D**(-0.5)))
        DP_kmeans_rf=proj/(kernel_normalize_constant)
        return DP_kmeans_rf
    return DP_rf
def random_sample_converter(x,kernel,kernel_normalize_constant,m):
    n_samples,n_features=x.shape
    landmarks=np.random.rand(m,n_features)
    def random_sample_rf(y):
        m=len(landmarks)
        n,d=y.shape
        Q,D,_=np.linalg.svd(kernel(landmarks,landmarks))
        proj=np.matmul(kernel(y,landmarks),np.einsum('ij,j->ij',Q,D**(-0.5)))
        rs_rf=proj/(kernel_normalize_constant)
        return rs_rf
    return random_sample_rf
from scipy.stats import truncnorm
def kmeans_converter(x,kernel,kernel_normalize_constant,m,epsilon):
    n_samples,n_features=x.shape
    num_cl=np.min([int(n_samples*0.01*epsilon),m])
    kmeans=KMeans(n_clusters=num_cl,bounds=(0,1), epsilon=epsilon).fit(x)
    landmarks_kmeans=kmeans.cluster_centers_
    if num_cl<m:
        A=np.matmul(np.sum(landmarks_kmeans**2,axis=1).reshape((num_cl,1)),np.ones((1,num_cl)))
        B=np.matmul(landmarks_kmeans,np.transpose(landmarks_kmeans))
        dist_matrix=(A-B)+np.transpose(A-B)
        for i in range(num_cl):
            dist_matrix[i,i]=100# just big number so that diagonal are ignored in the min operation under beneath
        nearest_dist=np.min(dist_matrix,axis=1)
        count=0
        j=0
        landmarks_rs=np.zeros((m-num_cl,n_features))
        while count<m-num_cl:
            landmarks_candi=np.zeros(n_features)
            for d in range(n_features):
                a=-landmarks_kmeans[j,d]/(nearest_dist[j]/2)
                b=(1-landmarks_kmeans[j,d])/(nearest_dist[j]/2)
                landmarks_candi[d]=truncnorm.rvs(a, b, loc=landmarks_kmeans[j,d], scale=nearest_dist[j]/2,size=1)
            landmarks_rs[count,:]=landmarks_candi
            count=count+1
            j=j+1
            if j>num_cl-1:
                j=0
        landmarks=np.concatenate((landmarks_kmeans,landmarks_rs))
    else:
        landmarks=landmarks_kmeans
    def kmeans_rf(y):
        m=len(landmarks)
        n,d=y.shape
        Q,D,_=np.linalg.svd(kernel(landmarks,landmarks))
        proj=np.matmul(kernel(y,landmarks),np.einsum('ij,j->ij',Q,D**(-0.5)))
        rs_rf=proj/(kernel_normalize_constant)
        return rs_rf
    return kmeans_rf
