
#ifndef SWAPPEDINSIDEMULTISETUNCHANGED_H_INCLUDED
#define SWAPPEDINSIDEMULTISETUNCHANGED_H_INCLUDED

#include "SwappedInside.h"
#include "MultisetUnchanged.h"
#include "EqualRangesPreservesCount.h"

/*
/@
  assigns a[i], a[k];
  ensures SwappedInside{Pre,Post}(a, i, k, n) ;
@/
void havoc_s(value_type* a, size_type i, size_type k, size_type n);

/@
  requires 0 <= _i <= _k < _n ;
  assigns _a[_i], _a[_k];
  ensures MultisetUnchanged{Pre, Post}(_a, _n);
@/
void SwappedInsideMultisetUnchanged_(value_type *_a, size_type _i, size_type _k, size_type _n){
  if(_i != _k && _a[_i] != _a[_k]){
  }
  
  havoc_s(_a, _i, _k, _n);

  if(_i == _k || _a[_i] == _a[_k]){
  } else {
    /@
      assert \forall value_type _v ; 
      \let swap = Count(_a, _i, _i+1, _v) + Count(_a, _k, _k+1, _v) ;
        Count(_a, 0, _n, _v) == 
	swap + 
	Count(_a, 0, _i, _v) + 
	Count(_a, _i+1, _k, _v) + 
	Count(_a, _k+1, _n, _v) ;
    @/
        Count{Pre}(_a, _k, _k+1, _v)+Count{Pre}(_a, _i, _i+1, _v) == 
	Count     (_a, _k, _k+1, _v)+Count     (_a, _i, _i+1, _v) ;
    @/
    /@
      assert \forall value_type _v ; 
      \let swap = Count{Pre}(_a, _k, _k+1, _v)+Count{Pre}(_a, _i, _i+1, _v) ;
        Count(_a, 0, _n, _v) == 
	swap + 
	Count{Pre}(_a, 0, _i, _v) + 
	Count{Pre}(_a, _i+1, _k, _v) + 
	Count{Pre}(_a, _k+1, _n, _v) ;
    @/
  }
}
*/

#define SwappedInsideMultisetUnchanged_pre(_a, _i, _k, _n)		\
  if(_i != _k && _a[_i] != _a[_k]){					\
									\
  }

#define SwappedInsideMultisetUnchanged(_K, _L, _a, _i, _k, _n)			\
  if(_i == _k || _a[_i] == _a[_k]){						\
  } else {									\
    /@										\
      assert \forall value_type _v ;						\
      \let swap = Count{_L}(_a, _i, _i+1, _v) + Count{_L}(_a, _k, _k+1, _v) ; 	\
        Count{_L}(_a, 0, _n, _v) ==						\
	  swap +								\
          Count{_L}(_a, 0, _i, _v) +						\
          Count{_L}(_a, _i+1, _k, _v) +						\
          Count{_L}(_a, _k+1, _n, _v) ;						\
    @/										\
       Count{_K}(_a, _k, _k+1, _v)+Count{_K}(_a, _i, _i+1, _v) ==		\
       Count{_L}(_a, _k, _k+1, _v)+Count{_L}(_a, _i, _i+1, _v) ; 		\
    @/										\
       Count{_L}(_a, 0, _i, _v) == Count{_K}(_a, 0, _i, _v) ; @/		\
       Count{_L}(_a, _i+1, _k, _v) == Count{_K}(_a, _i+1, _k, _v) ; @/		\
       Count{_L}(_a, _k+1, _n, _v) == Count{_K}(_a, _k+1, _n, _v) ; @/		\
    /@										\
      assert \forall value_type _v ;						\
      \let swap = Count{_K}(_a, _k, _k+1, _v) + Count{_K}(_a, _i, _i+1, _v) ; 	\
        Count{_L}(_a, 0, _n, _v) ==						\
	  swap +								\
	  Count{_K}(_a, 0, _i, _v) +						\
	  Count{_K}(_a, _i+1, _k, _v) +						\
	  Count{_K}(_a, _k+1, _n, _v) ;						\
    @/										\
       Count{_L}(_a, 0, _n, _v) == Count{_K}(_a, 0, _n, _v) ; @/		\
  }  


#endif /* SWAPPEDINSIDEMULTISETUNCHANGED_H_INCLUDED */

