
#include "partial_sort_copy.h"

#include "../../mutating/copy/copy.h"
#include "../../heap/make_heap/make_heap.h"
#include "../../heap/pop_heap/pop_heap.h"
#include "../../heap/push_heap/push_heap.h"
#include "../../heap/sort_heap/sort_heap.h"



//#define DANGEROUS_HYPOTHESES		/* needed for g7,gC,h1,h4,h5 */



#ifdef DANGEROUS_HYPOTHESES
#include "CountBounds.h"
#include "CountLemmas.h"
#include "LowerBound.h"
#include "HeapMaximum.h"

#endif



void partial_sort_copy(const value_type* a, size_type m,
                             value_type* b, size_type n)
{
  if (n > 0u) {

    copy(a, n, b);

    //@ ghost L1:

    make_heap(b, n);

    /*@
      loop invariant c1: 0 <= i <= m;
      loop invariant c2: IsLeastPartOf(a, i, b, n);
      loop invariant c3: IsHeap(b, n);
      loop assigns   c4: b[0..n-1], i;
      loop variant   c5: m-i;
    */
    for (size_type i = n; i < m; ++i) {
      if (a[i] < b[0]) {	// a[i] better than heap root, swap-in
	value_type const old_b0 = b[0];

	//@ ghost L2:

#ifdef DANGEROUS_HYPOTHESES
#endif

	pop_heap(b, n);

	//@ ghost L3:

	b[n-1] = a[i];

	//@ ghost L4:

	push_heap(b, n);

	//@ ghost L5:
      } else {
      }
    }

    //@ ghost L6:

    sort_heap(b, n);
  }
}

