#ifdef _IN_LIST_MAIN_FILE

/*@
  requires index >= 0 && n >= 0 && index + n < MAX_SIZE ;
  requires ValidArray : \valid( array + (0 .. MAX_SIZE - 1) );
  assigns \nothing ;
  
  ensures \result == index_of(item, array, index, index+n) ;

  behavior contains:
    assumes \exists integer i ; index <= i < index+n && array[i] == item ;
    ensures index <= \result < index+n ;
  
  behavior does_not_contain:
    assumes \forall integer i ; index <= i < index+n ==> array[i] != item ;
    ensures \result == index+n ;

  disjoint behaviors ;
  complete behaviors ;
*/
int array_find(struct list* item, struct list** array, int index, int n){
  int i = index ;

  /*@
    loop invariant index <= i <= index+n ;
    loop invariant \forall integer j ; index <= j < i ==> array[j] != item ;
    loop assigns i ;
    loop variant index + n - i ;
  */
  while(i < index+n){
    if(array[i] == item){
      return i ;
    }
    ++i;
  }
  return i;
}

#endif
