#ifdef _IN_LIST_MAIN_FILE

/*@
  requires \valid(list);
  requires ValidArray : \valid( array + (0 .. MAX_SIZE - 1) );
  requires EnoughSpace : index + n + 1 <= MAX_SIZE; 
  requires Linked : linked_n (root, array, index, n, bound);

  requires GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  requires GhostSeparation: \separated(list, *(array + (index .. index + n - 1))) ;
  requires GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  requires Separation: 
    \forall integer y ; 
      index <= y < index + n ==> 
        \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

  requires Separation : 
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && z != y ==> 
        \separated( *(array + y), *(array + z));

  requires Unique:
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && y != z ==> 
        array[y] != array[z];

  assigns array[index .. index + n];

  ensures GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  ensures GhostSeparation: \separated(list, *(array + (index + 1 .. index + n))) ;
  ensures GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  ensures Separation: 
    \forall integer y ; 
      index + 1 <= y < index + n + 1 ==> 
        \separated( * (array + y), array + (0 .. MAX_SIZE - 1));
  ensures Separation : 
    \forall integer y, z; 
      index + 1 <= y < index + n + 1 && index + 1 <= z < index + n + 1 && z != y ==> 
        \separated( *(array + y), *(array + z));
  ensures Unique:
    \forall integer y, z; 
      index <= y < index + n + 1 && index <= z < index + n + 1 && y != z ==> 
        array[y] != array[z];

  ensures *list == \old(*list);

  ensures SubArraySwipeRight : array_swipe_right{Pre, Post} (array, index + 1, index + n + 1);
  ensures StillLinked: linked_n(root, array, index + 1, n, bound);

*/
void
array_push (struct list **array, int index, int n,
	    list_t list, struct list *root, struct list *bound)
{
  if( n == 0 )
    return;
  
  int i = index + n;
  struct list *le = bound;
  int sup = 0 ; 
  /*@
    loop invariant *list == \at(*list, Pre) ;
    loop invariant IInBounds : index <= i <= index + n ;
    loop invariant i == index + n <==> sup == 0;
    loop invariant i <  index + n <==> sup == 1;
    loop invariant UnchangedLeft: unchanged{Pre, Here} (array, index, i);
    loop invariant AfterISwipeRight: array_swipe_right{Pre, Here} (array, i + 1, index + n + 1);
    loop invariant LeftLinked : linked_n(root, array, index, i - index, le);
    loop invariant RightLinked: linked_n(le, array, i + 1, n - (i - index), bound);
    loop invariant Separation:
        \forall integer y ; index <= y < index + n + sup ==> 
	  \separated( * (array + y), array + (0 .. MAX_SIZE - 1));
    loop invariant GhostSeparation: 
        \separated(list, *(array + (i+1 .. index + n))) ;
    loop assigns i, le, sup, array[index+1 .. index + n];
    loop variant i - index;
  */
  while (i > index){
    sup = 1 ;
    struct list *leNext;

    //@ ghost Before:      
    array[i] = array[i-1];

    
   
    /*@ ghost int NN = n - (i - index), II = i + 1; */

    i--;
    

    if( i == index ){
      leNext = root;
    }
    else{
      leNext = array[i];
      
      /*@ ghost int NNN = i - index, III = index; */
 


      
    }
    le = leNext;
   
  }
  //@ ghost AlmostEnd:  
  array[index] = NULL ; // USELESS ?

}

#endif
