(* ---------------------------------------------------------- *)
(* --- Axiomatic 'Index_of_item'                          --- *)
(* ---------------------------------------------------------- *)

Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.
Require Import Memory.

Parameter L_index_of : farray addr addr -> addr -> addr -> Z -> Z -> Z.

Hypothesis Q_no_more_elements: forall (i_1 i : Z),
  forall (t : farray addr addr), forall (a_1 a : addr), ((0 <= i)%Z) ->
  ((i <= i_1)%Z) -> ((((L_index_of t a_1 a i_1%Z i%Z)) = i)%Z).

Require Import Compound.

Hypothesis Q_found_item: forall (i_1 i : Z), forall (t : farray addr addr),
  forall (a_1 a : addr), ((t.[ (shift_PTR a i_1%Z) ]) = a_1) ->
  ((0 <= i_1)%Z) -> ((i_1 < i)%Z) ->
  ((((L_index_of t a_1 a i_1%Z i%Z)) = i_1)%Z).

Hypothesis Q_not_the_item: forall (i_1 i : Z), forall (t : farray addr addr),
  forall (a_1 a : addr), ((t.[ (shift_PTR a i_1%Z) ]) <> a_1) ->
  ((0 <= i_1)%Z) -> ((i_1 < i)%Z) ->
  ((((L_index_of t a_1 a (1%Z + i_1%Z)%Z i%Z))
    = ((L_index_of t a_1 a i_1%Z i%Z)))%Z).

