(* ---------------------------------------------------------- *)
(* --- Global Definitions                                 --- *)
(* ---------------------------------------------------------- *)

Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.
Require Import Memory.
Require Import Compound.

Inductive P_linked_n : array Z -> farray addr addr -> addr -> addr -> Z ->
    Z -> addr -> Prop :=
    | Q_linked_n_bound: forall (i : Z), forall (t : array Z),
        forall (t_1 : farray addr addr), forall (a_1 a : addr),
        ((0 <= i)%Z) -> ((i <= 2147483646)%Z) ->
        ((P_linked_n t t_1 a a_1 i%Z 0%Z a))
    | Q_linked_n_cons: forall (i_1 i : Z), forall (t : array Z),
        forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr),
        let x := (i%Z + i_1%Z)%Z in
        ((t_1.[ (shift_PTR a_1 i_1%Z) ]) = a_2) -> ((0 < i)%Z) ->
        ((0 <= i_1)%Z) -> ((0 <= x)%Z) -> ((x <= 2147483646)%Z) ->
        ((valid_rw t a_2 2%Z)) ->
        ((P_linked_n t t_1 (t_1.[ (shiftfield_F1_list_next a_2) ]) a_1
           (1%Z + i_1%Z)%Z (i%Z - 1%Z)%Z a)) ->
        ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)).

