(* ---------------------------------------------------------- *)
(* --- Memory Compound Updates                            --- *)
(* ---------------------------------------------------------- *)

Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.
Require Import Memory.

Definition shift_PTR (p : addr) (k : Z) : addr := (shift p k%Z).

Definition shiftfield_F1_list_next (p : addr) : addr := (shift p 0%Z).

Definition shiftfield_F1_list_k (p : addr) : addr := (shift p 1%Z).

Require Import S1_list.

Definition Load_S1_list (p : addr) (Mint_0 : farray addr Z)
    (Mptr_0 : farray addr addr) : S1_list :=
    {|
      F1_list_k := (Mint_0.[ (shiftfield_F1_list_k p) ])%Z ;F1_list_next := Mptr_0.[ 
                                                              (shiftfield_F1_list_next
                                                                p) ] |}.

Hypothesis Q_Load_S1_list_update_Mint: forall (i : Z),
  forall (t : farray addr Z), forall (t_1 : farray addr addr),
  forall (a_1 a : addr), ((separated a_1 2%Z a 1%Z)) ->
  (((Load_S1_list a_1 (t.[ a <- (i)%Z ]) t_1)) = ((Load_S1_list a_1 t t_1))).

Hypothesis Q_Load_S1_list_eqmem_Mint: forall (i : Z),
  forall (t_1 t : farray addr Z), forall (t_2 : farray addr addr),
  forall (a_1 a : addr), ((included a_1 2%Z a i%Z)) ->
  ((eqmem t_1 t a i%Z)) ->
  (((Load_S1_list a_1 t_1 t_2)) = ((Load_S1_list a_1 t t_2))).

Hypothesis Q_Load_S1_list_havoc_Mint: forall (i : Z),
  forall (t_1 t : farray addr Z), forall (t_2 : farray addr addr),
  forall (a_1 a : addr), ((separated a_1 2%Z a i%Z)) ->
  ((havoc t_1 t a i%Z)) ->
  (((Load_S1_list a_1 t_1 t_2)) = ((Load_S1_list a_1 t t_2))).

Hypothesis Q_Load_S1_list_update_Mptr: forall (t : farray addr Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr),
  ((separated a_2 2%Z a_1 1%Z)) ->
  (((Load_S1_list a_2 t (t_1.[ a_1 <- a ]))) = ((Load_S1_list a_2 t t_1))).

Hypothesis Q_Load_S1_list_eqmem_Mptr: forall (i : Z),
  forall (t : farray addr Z), forall (t_2 t_1 : farray addr addr),
  forall (a_1 a : addr), ((included a_1 2%Z a i%Z)) ->
  ((eqmem t_2 t_1 a i%Z)) ->
  (((Load_S1_list a_1 t t_2)) = ((Load_S1_list a_1 t t_1))).

Hypothesis Q_Load_S1_list_havoc_Mptr: forall (i : Z),
  forall (t : farray addr Z), forall (t_2 t_1 : farray addr addr),
  forall (a_1 a : addr), ((separated a_1 2%Z a i%Z)) ->
  ((havoc t_2 t_1 a i%Z)) ->
  (((Load_S1_list a_1 t t_2)) = ((Load_S1_list a_1 t t_1))).

