(* ---------------------------------------------------------- *)
(* --- Struct 'list'                                      --- *)
(* ---------------------------------------------------------- *)

Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.
Require Import Memory.

Record S1_list : Type := { F1_list_next : addr ; F1_list_k : Z }.
Require Import Cint.

Definition IsS1_list (S : S1_list) : Prop := (is_sint32 (F1_list_k S)%Z).

Definition EqS1_list (S : S1_list) (S_1 : S1_list) : Prop :=
    (((F1_list_k S_1) = (F1_list_k S))%Z) /\
      ((F1_list_next S_1) = (F1_list_next S)).

