(* ---------------------------------------------------------- *)
(* --- Lemma 'equiv_index_of'                             --- *)
(* ---------------------------------------------------------- *)
Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.

(* --- Global Definitions (continued #1) --- *)
Require Import Memory.

Require Import Compound.
Require Import A_Index_of_item.

Hypothesis Q_index_of_existing_item: forall (i_1 i : Z),
  forall (t : farray addr addr), forall (a_1 a : addr),
  let x := ((L_index_of t a_1 a i_1%Z i%Z))%Z in ((0 <= i)%Z) ->
  ((0 <= i_1)%Z) ->
  (exists i_2 : Z, ((t.[ (shift_PTR a i_2%Z) ]) = a_1) /\ ((i_2 < i)%Z) /\
   ((i_1 <= i_2)%Z)) -> (((x < i)%Z) /\ ((i_1 <= x)%Z)).

Hypothesis Q_index_of_bounds: forall (i_1 i : Z),
  forall (t : farray addr addr), forall (a_1 a : addr),
  let x := ((L_index_of t a_1 a i_1%Z i%Z))%Z in ((i_1 <= i)%Z) ->
  ((0 <= i_1)%Z) -> (((x <= i)%Z) /\ ((i_1 <= x)%Z)).

Hypothesis Q_index_of_unexisting_item: forall (i_1 i : Z),
  forall (t : farray addr addr), forall (a_1 a : addr), ((0 <= i)%Z) ->
  ((0 <= i_1)%Z) ->
  (forall (i_2 : Z), ((i_2 < i)%Z) -> ((i_1 <= i_2)%Z) ->
   ((t.[ (shift_PTR a i_2%Z) ]) <> a_1)) ->
  ((((L_index_of t a_1 a i_1%Z i%Z)) = i)%Z).

Hypothesis Q_index_of_not_in_subrange: forall (i_2 i_1 i : Z),
  forall (t : farray addr addr), forall (a_1 a : addr), ((0 <= i)%Z) ->
  ((i_2 <= i_1)%Z) -> ((0 <= i_2)%Z) ->
  (forall (i_3 : Z), ((i_3 < i_1)%Z) -> ((i_2 <= i_3)%Z) ->
   ((t.[ (shift_PTR a i_3%Z) ]) <> a_1)) ->
  ((((L_index_of t a_1 a i_2%Z i%Z)) = ((L_index_of t a_1 a i_1%Z i%Z)))%Z).

Require Import Axiomatic.

Hypothesis Q_linked_next_index: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((2 <= i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shift_PTR a_1 (1%Z + i_1%Z)%Z) ]) =
   (t_1.[ (shiftfield_F1_list_next a_2) ])).

Hypothesis Q_linked_next_valid: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((2 <= i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((valid_rw t (t_1.[ (shiftfield_F1_list_next a_2) ]) 2%Z)).

Definition P_array_swipe_left (Mptr_0 : farray addr addr)
    (Mptr_1 : farray addr addr) (array_0 : addr) (down_0 : Z) (up_0 : Z)
    : Prop :=
    forall (i : Z), ((down_0 <= i)%Z) -> ((i < up_0)%Z) ->
      ((Mptr_1.[ (shift_PTR array_0 (1%Z + i%Z)%Z) ]) =
       (Mptr_0.[ (shift_PTR array_0 i%Z) ])).

Hypothesis Q_not_in_not_in_swipe_left: forall (i_1 i : Z),
  forall (t_1 t : farray addr addr), forall (a_1 a : addr),
  let x := (i%Z + i_1%Z)%Z in
  ((P_array_swipe_left t_1 t a i_1%Z (i%Z + i_1%Z - 1%Z)%Z)) ->
  (forall (i_2 : Z), ((i_1 < i_2)%Z) -> ((i_2 < x)%Z) ->
   ((separated a_1 1%Z (t.[ (shift_PTR a i_2%Z) ]) 2%Z))) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> (((2 + i_2) <= x)%Z) ->
   ((separated a_1 1%Z (t_1.[ (shift_PTR a i_2%Z) ]) 2%Z))).

Hypothesis Q_linked_root_not_bound_n_sup_zero: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), (a_2 <> a) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) -> ((0 < i)%Z).

Hypothesis Q_linked_zero_root_equal_bound: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((i = 0)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) -> (a_2 = a).

Hypothesis Q_linked_not_empty_head_position: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shift_PTR a_1 i_1%Z) ]) = a_2).

Hypothesis Q_linked_merge_segment_right: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), ((0 <= i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) ->
  ((P_linked_n t t_1 a a_2 (i%Z + i_1%Z)%Z 1%Z a_1)) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)).

Hypothesis Q_linked_merge_segment: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), ((0 <= i)%Z) -> ((0 <= i_1)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) ->
  ((P_linked_n t t_1 a a_2 (i_1%Z + i_2%Z)%Z i%Z a_1)) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)).

Hypothesis Q_linked_split_segment_right_direct: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), let x := (i%Z + i_1%Z)%Z in
  ((t_1.[ (shift_PTR a_2 x) ]) = a) -> ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) /\
   ((P_linked_n t t_1 a a_2 x 1%Z a_1))).

Hypothesis Q_linked_split_segment_right: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_2 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a) ->
  ((0 < i)%Z) -> ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) /\
   ((P_linked_n t t_1 a a_2 (i%Z + i_1%Z)%Z 1%Z a_1))).

Hypothesis Q_linked_split_segment_left: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr),
  let a_3 := t_1.[ (shiftfield_F1_list_next a_2) ] in ((0 < i)%Z) ->
  ((((P_linked_n t t_1 a_2 a_1 i_1%Z 1%Z a_3)) /\
    ((P_linked_n t t_1 a_3 a_1 (1%Z + i_1%Z)%Z (i%Z - 1%Z)%Z a))) <->
   ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a))).

Hypothesis Q_linked_split_segment_direct: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), let x := (i_1%Z + i_2%Z)%Z in
  ((t_1.[ (shift_PTR a_2 x) ]) = a) -> ((0 < i)%Z) -> ((0 < i_1)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) /\
   ((P_linked_n t t_1 a a_2 x i%Z a_1))).

Hypothesis Q_linked_split_segment: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_2 (i_1%Z + i_2%Z - 1%Z)%Z) ])) ]) = a) ->
  ((0 < i_1)%Z) -> ((0 <= i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) /\
   ((P_linked_n t t_1 a a_2 (i_1%Z + i_2%Z)%Z i%Z a_1))).

Hypothesis Q_linked_valid_range: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> ((i_2 < (i + i_1))%Z) ->
   ((valid_rw t (t_1.[ (shift_PTR a_1 i_2%Z) ]) 2%Z))).

Hypothesis Q_linked_max_value_index_n: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (((i + i_1) <= 2147483646)%Z).

Hypothesis Q_linked_n_bounds: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr),
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((((i = 0)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483646)%Z)) \/
   (((0 < i)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483645)%Z))).

Hypothesis Q_linked_last_next_index_bound: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_1 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a).

Hypothesis Q_linked_n_all_elements_not_null: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> ((i_2 < (i + i_1))%Z) ->
   ((t_1.[ (shift_PTR a_1 i_2%Z) ]) <> (null))).

Hypothesis Q_linked_n_starting_from_null_empty: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr), forall (a : addr),
  ((P_linked_n t t_1 (null) a i_1%Z i%Z (null))) -> ((i = 0)%Z).

Require Import S1_list.

Definition P_unchanged (Malloc_0 : array Z) (Mptr_0 : farray addr addr)
    (Mint_0 : farray addr Z) (Malloc_1 : array Z) (Mptr_1 : farray addr addr)
    (Mint_1 : farray addr Z) (array_0 : addr) (down_0 : Z) (up_0 : Z)
    : Prop :=
    forall (i : Z), let a := (shift_PTR array_0 i%Z) in
      let a_1 := Mptr_0.[ a ] in let a_2 := Mptr_1.[ a ] in
      ((down_0 <= i)%Z) -> ((i < up_0)%Z) ->
      ((a_1 = a_2) /\
       ((EqS1_list ((Load_S1_list a_2 Mint_1 Mptr_1))
          ((Load_S1_list a_1 Mint_0 Mptr_0)))) /\
       (((valid_rw Malloc_1 a_2 2%Z)) -> ((valid_rw Malloc_0 a_1 2%Z)))).

Hypothesis Q_stay_linked: forall (i_1 i : Z), forall (t_1 t : array Z),
  forall (t_3 t_2 : farray addr Z), forall (t_5 t_4 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_4 a_2 a_1 i_1%Z i%Z a)) ->
  ((P_unchanged t_1 t_5 t_3 t t_4 t_2 a_1 i_1%Z (i%Z + i_1%Z)%Z)) ->
  ((P_linked_n t_1 t_5 a_2 a_1 i_1%Z i%Z a)).

Goal
  forall (i_1 i : Z),
  forall (t : farray addr addr),
  forall (a_1 a : addr),
  (((L_index_of t a_1 a i_1%Z i%Z))
   = ((L_index_of_exec t a_1 a i_1%Z i%Z)))%Z.

Proof.
  assert(addr_dec: forall (a a': addr), { a = a' } + { a <> a' })
    by (repeat(decide equality)).
  intros down up mem item array.
  pose(H:= Axiomatic.FixL_index_of_exec down up mem item array);
      unfold itep in H.
  destruct (Z_lt_ge_dec down 0)  as [Hlt0_down | Hge0_down].
  - assert(up < 0 \/ down < 0) by omega.
    destruct H as [ H _ ].
    rewrite H by auto.
    rewrite A_Index_of_item.Q_invalid_bounds by auto.
    trivial.
  - destruct (Z_lt_ge_dec up 0)  as [Hlt0_up | Hge0_up].
    + assert(up < 0 \/ down < 0) by omega.
      destruct H as [ H _ ].
      rewrite H by auto.
      rewrite A_Index_of_item.Q_invalid_bounds by auto.
      trivial.
    + assert(HH: ~(up <0 \/ down <0)) by omega.
      destruct H as [ _ H ]. specialize(H HH).
      destruct(Z_lt_ge_dec down up) as [ Hlt | Hge].
      * clear H HH.
        set(len:=up-down).
        assert(HH: down = up-len) by (unfold len; omega).
        rewrite HH in *. clear HH. 
        generalize dependent len. 
        intros len Hu Hl. clear down.
        assert(Hlen: 0 < len) by omega. revert Hu Hl. 
        apply natlike_ind with (x:=len); try omega.
        -- intros Hl Hu. replace (up-0) with up by omega.
           pose(H:= Axiomatic.FixL_index_of_exec up up mem item array);
           unfold itep in H.
           destruct H as [ _ H].
           assert(HH:~(up<0 \/ up<0)) by omega.
           specialize (H HH).
           destruct H as [H _ ]. rewrite H by omega.
           rewrite A_Index_of_item.Q_found_item by (auto;omega).
           trivial.
        -- intros x Hx IH Hl Hu.
           pose(H:= Axiomatic.FixL_index_of_exec (up - Z.succ x) up mem item array);
             unfold itep in H.
           destruct H as [ _ H].
           assert(HH: ~ (up < 0 \/ up - Z.succ x < 0) ) by omega.
           specialize(H HH). destruct H as [ _ H]. clear HH.
           assert(HH: ~ 0 <= up <= up - Z.succ x) by omega.
           specialize(H HH).
           destruct(addr_dec (mem .[ shift_PTR array (up -Z.succ x)]) item) 
             as [ Heq | Hneq ].
           ++ destruct H as [ H _ ].
              rewrite H by (split;auto;omega).
              rewrite A_Index_of_item.Q_found_item by (auto;omega).
              trivial.
           ++ destruct H as [ _ H ].
              rewrite <- H by (contradict Hneq; intuition).
              rewrite <- A_Index_of_item.Q_not_the_item by (auto;omega).
              replace (1+ (up-Z.succ x)) with (up -x) by omega.
              destruct(Z.eq_dec (up - x) up)  as [ Heq' | Hneq'].
              ** rewrite Heq'. clear H HH.
                 pose(H:= Axiomatic.FixL_index_of_exec up up mem item array);
                   unfold itep in H.
                 destruct H as [_ H ].
                 assert(HH:~(up<0 \/ up<0)) by omega.
                 specialize (H HH).
                 destruct H as [H _ ]. rewrite H by omega.
                 rewrite A_Index_of_item.Q_no_more_elements by (auto;omega).
                 trivial.
              ** now rewrite IH by omega.
      * destruct H as [ H _ ].
        rewrite H by (auto; omega).
        rewrite A_Index_of_item.Q_no_more_elements 
          by (auto;omega).
        trivial.
Qed.

