(* ---------------------------------------------------------- *)
(* --- Lemma 'equiv_linked'                               --- *)
(* ---------------------------------------------------------- *)
Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.

(* --- Global Definitions (continued #1) --- *)
Require Import Memory.

Require Import A_Index_of_item.
Require Import Axiomatic.

Hypothesis Q_equiv_index_of: forall (i_1 i : Z),
  forall (t : farray addr addr), forall (a_1 a : addr),
  (((L_index_of t a_1 a i_1%Z i%Z))
   = ((L_index_of_exec t a_1 a i_1%Z i%Z)))%Z.

Require Import Compound.

Hypothesis Q_array_view_last_next_index_bound: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((0 < i)%Z) -> ((0 <= i_1)%Z) ->
  (((L_array_view_exec t_1 a_2 a_1 i_1%Z i%Z a))=true) ->
  (forall (i_2 : Z), ((0 <= i_2)%Z) -> ((i_2 < i)%Z) ->
   ((valid_rw t (t_1.[ (shift_PTR a_1 (i_2%Z + i_1%Z)%Z) ]) 2%Z))) ->
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_1 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a).

Hypothesis Q_array_view_exec_smaller: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((i < i_1)%Z) -> ((0 <= i_1)%Z) ->
  ((0 <= i_2)%Z) -> (((L_array_view_exec t_1 a_2 a_1 i_2%Z i_1%Z a))=true) ->
  (forall (i_3 : Z), ((0 <= i_3)%Z) -> ((i_3 < i_1)%Z) ->
   ((valid_rw t (t_1.[ (shift_PTR a_1 (i_3%Z + i_2%Z)%Z) ]) 2%Z))) ->
  (((L_array_view_exec t_1 a_2 a_1 i_2%Z i%Z
      (t_1.[ (shift_PTR a_1 (i%Z + i_2%Z)%Z) ])))=true).

Hypothesis Q_index_of_existing_item: forall (i_1 i : Z),
  forall (t : farray addr addr), forall (a_1 a : addr),
  let x := ((L_index_of t a_1 a i_1%Z i%Z))%Z in ((0 <= i)%Z) ->
  ((0 <= i_1)%Z) ->
  (exists i_2 : Z, ((t.[ (shift_PTR a i_2%Z) ]) = a_1) /\ ((i_2 < i)%Z) /\
   ((i_1 <= i_2)%Z)) -> (((x < i)%Z) /\ ((i_1 <= x)%Z)).

Hypothesis Q_index_of_bounds: forall (i_1 i : Z),
  forall (t : farray addr addr), forall (a_1 a : addr),
  let x := ((L_index_of t a_1 a i_1%Z i%Z))%Z in ((i_1 <= i)%Z) ->
  ((0 <= i_1)%Z) -> (((x <= i)%Z) /\ ((i_1 <= x)%Z)).

Hypothesis Q_index_of_unexisting_item: forall (i_1 i : Z),
  forall (t : farray addr addr), forall (a_1 a : addr), ((0 <= i)%Z) ->
  ((0 <= i_1)%Z) ->
  (forall (i_2 : Z), ((i_2 < i)%Z) -> ((i_1 <= i_2)%Z) ->
   ((t.[ (shift_PTR a i_2%Z) ]) <> a_1)) ->
  ((((L_index_of t a_1 a i_1%Z i%Z)) = i)%Z).

Hypothesis Q_index_of_not_in_subrange: forall (i_2 i_1 i : Z),
  forall (t : farray addr addr), forall (a_1 a : addr), ((0 <= i)%Z) ->
  ((i_2 <= i_1)%Z) -> ((0 <= i_2)%Z) ->
  (forall (i_3 : Z), ((i_3 < i_1)%Z) -> ((i_2 <= i_3)%Z) ->
   ((t.[ (shift_PTR a i_3%Z) ]) <> a_1)) ->
  ((((L_index_of t a_1 a i_2%Z i%Z)) = ((L_index_of t a_1 a i_1%Z i%Z)))%Z).

Hypothesis Q_linked_next_index: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((2 <= i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shift_PTR a_1 (1%Z + i_1%Z)%Z) ]) =
   (t_1.[ (shiftfield_F1_list_next a_2) ])).

Hypothesis Q_linked_next_valid: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((2 <= i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((valid_rw t (t_1.[ (shiftfield_F1_list_next a_2) ]) 2%Z)).

Definition P_array_swipe_left (Mptr_0 : farray addr addr)
    (Mptr_1 : farray addr addr) (array_0 : addr) (down_0 : Z) (up_0 : Z)
    : Prop :=
    forall (i : Z), ((down_0 <= i)%Z) -> ((i < up_0)%Z) ->
      ((Mptr_1.[ (shift_PTR array_0 (1%Z + i%Z)%Z) ]) =
       (Mptr_0.[ (shift_PTR array_0 i%Z) ])).

Hypothesis Q_not_in_not_in_swipe_left: forall (i_1 i : Z),
  forall (t_1 t : farray addr addr), forall (a_1 a : addr),
  let x := (i%Z + i_1%Z)%Z in
  ((P_array_swipe_left t_1 t a i_1%Z (i%Z + i_1%Z - 1%Z)%Z)) ->
  (forall (i_2 : Z), ((i_1 < i_2)%Z) -> ((i_2 < x)%Z) ->
   ((separated a_1 1%Z (t.[ (shift_PTR a i_2%Z) ]) 2%Z))) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> (((2 + i_2) <= x)%Z) ->
   ((separated a_1 1%Z (t_1.[ (shift_PTR a i_2%Z) ]) 2%Z))).

Hypothesis Q_linked_root_not_bound_n_sup_zero: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), (a_2 <> a) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) -> ((0 < i)%Z).

Hypothesis Q_linked_zero_root_equal_bound: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((i = 0)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) -> (a_2 = a).

Hypothesis Q_linked_not_empty_head_position: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shift_PTR a_1 i_1%Z) ]) = a_2).

Hypothesis Q_linked_merge_segment_right: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), ((0 <= i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) ->
  ((P_linked_n t t_1 a a_2 (i%Z + i_1%Z)%Z 1%Z a_1)) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)).

Hypothesis Q_linked_merge_segment: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), ((0 <= i)%Z) -> ((0 <= i_1)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) ->
  ((P_linked_n t t_1 a a_2 (i_1%Z + i_2%Z)%Z i%Z a_1)) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)).

Hypothesis Q_linked_split_segment_right_direct: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), let x := (i%Z + i_1%Z)%Z in
  ((t_1.[ (shift_PTR a_2 x) ]) = a) -> ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) /\
   ((P_linked_n t t_1 a a_2 x 1%Z a_1))).

Hypothesis Q_linked_split_segment_right: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_2 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a) ->
  ((0 < i)%Z) -> ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) /\
   ((P_linked_n t t_1 a a_2 (i%Z + i_1%Z)%Z 1%Z a_1))).

Hypothesis Q_linked_split_segment_left: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr),
  let a_3 := t_1.[ (shiftfield_F1_list_next a_2) ] in ((0 < i)%Z) ->
  ((((P_linked_n t t_1 a_2 a_1 i_1%Z 1%Z a_3)) /\
    ((P_linked_n t t_1 a_3 a_1 (1%Z + i_1%Z)%Z (i%Z - 1%Z)%Z a))) <->
   ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a))).

Hypothesis Q_linked_split_segment_direct: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), let x := (i_1%Z + i_2%Z)%Z in
  ((t_1.[ (shift_PTR a_2 x) ]) = a) -> ((0 < i)%Z) -> ((0 < i_1)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) /\
   ((P_linked_n t t_1 a a_2 x i%Z a_1))).

Hypothesis Q_linked_split_segment: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_2 (i_1%Z + i_2%Z - 1%Z)%Z) ])) ]) = a) ->
  ((0 < i_1)%Z) -> ((0 <= i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) /\
   ((P_linked_n t t_1 a a_2 (i_1%Z + i_2%Z)%Z i%Z a_1))).

Hypothesis Q_linked_valid_range: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> ((i_2 < (i + i_1))%Z) ->
   ((valid_rw t (t_1.[ (shift_PTR a_1 i_2%Z) ]) 2%Z))).

Hypothesis Q_linked_max_value_index_n: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (((i + i_1) <= 2147483646)%Z).

Hypothesis Q_linked_n_bounds: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr),
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((((i = 0)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483646)%Z)) \/
   (((0 < i)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483645)%Z))).

Hypothesis Q_linked_last_next_index_bound: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_1 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a).

Hypothesis Q_linked_n_all_elements_not_null: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> ((i_2 < (i + i_1))%Z) ->
   ((t_1.[ (shift_PTR a_1 i_2%Z) ]) <> (null))).

Hypothesis Q_linked_n_starting_from_null_empty: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr), forall (a : addr),
  ((P_linked_n t t_1 (null) a i_1%Z i%Z (null))) -> ((i = 0)%Z).

Require Import S1_list.

Definition P_unchanged (Malloc_0 : array Z) (Mptr_0 : farray addr addr)
    (Mint_0 : farray addr Z) (Malloc_1 : array Z) (Mptr_1 : farray addr addr)
    (Mint_1 : farray addr Z) (array_0 : addr) (down_0 : Z) (up_0 : Z)
    : Prop :=
    forall (i : Z), let a := (shift_PTR array_0 i%Z) in
      let a_1 := Mptr_0.[ a ] in let a_2 := Mptr_1.[ a ] in
      ((down_0 <= i)%Z) -> ((i < up_0)%Z) ->
      ((a_1 = a_2) /\
       ((EqS1_list ((Load_S1_list a_2 Mint_1 Mptr_1))
          ((Load_S1_list a_1 Mint_0 Mptr_0)))) /\
       (((valid_rw Malloc_1 a_2 2%Z)) -> ((valid_rw Malloc_0 a_1 2%Z)))).

Hypothesis Q_stay_linked: forall (i_1 i : Z), forall (t_1 t : array Z),
  forall (t_3 t_2 : farray addr Z), forall (t_5 t_4 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_4 a_2 a_1 i_1%Z i%Z a)) ->
  ((P_unchanged t_1 t_5 t_3 t t_4 t_2 a_1 i_1%Z (i%Z + i_1%Z)%Z)) ->
  ((P_linked_n t_1 t_5 a_2 a_1 i_1%Z i%Z a)).

Goal
  forall (i_1 i : Z),
  forall (t : array Z),
  forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr),
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) <->
  ((P_linked_exec t t_1 a_2 a_1 i_1%Z i%Z a)).

Proof.
  intros index size mem_i mem root array bound.
  split; intro H; unfold P_linked_exec in *.
  - induction H 
      as [index mem_i mem array bound Hl Hu | 
          index size mem_i mem root array bound x Heq Hl Hl' Hl'' Hu Hv Hlinked IH].
    + subst; repeat split; auto; try omega.
      pose(Hav:= Axiomatic.FixL_array_view_exec index 0 mem bound array bound); 
        unfold itep in Hav; destruct Hav as [ Hav _ ].
      now apply Hav.
    + subst x; split;[idtac|split;[idtac|split]]; auto; try omega.
      pose(Hav:= Axiomatic.FixL_array_view_exec index size mem root array bound);
        unfold itep in Hav; destruct Hav as [ _ Hav ].
      assert(HH: size <> 0) by omega; specialize (Hav HH); clear HH.
      destruct IH as [ IH1 [IH2 [IH3 [IH4 IH5]]]].
      match goal with 
      | [ Hav : ?cond <-> _ |- _ ] => 
        assert(Hcond: cond) by auto;
        destruct Hav as [Hav Hav'];
        specialize(Hav Hcond)
      end.
      rewrite Hav; split; auto.
      intros i Hli Hui.
      destruct(Z.eq_dec index i) as [ Heq_index | Hneq_index ].
      * subst; trivial.
      * apply IH5 ; omega.
  - destruct H as [Hindex[H2[H3[H4 H5]]]].
    generalize dependent bound.
    generalize dependent size. intros size Hl.
    assert(0<=size) by auto. revert Hl.
    apply natlike_rec with (x:=size); auto.
    + intros _ H1 H2 bound H3.
      pose(Hav:= Axiomatic.FixL_array_view_exec index 0 mem root array bound);
        unfold itep in Hav.
      assert(root = bound) by now apply Hav.
      subst; constructor; omega.
    + intros x Hx IH HlSx HuSx Hav bound Hv.
      replace (Z.succ x) with (1+x) by auto with zarith.
      set(bound' := mem .[ shift_PTR array (x+index) ]).
      assert(HH: P_linked_n mem_i mem root array index x bound').
      {
        apply IH; try solve [intuition].
        subst bound'.
        eapply Q_array_view_exec_smaller; eauto with zarith.
      }
      eapply Q_linked_merge_segment_right; eauto.
      constructor; auto with zarith.
      * subst bound'; apply Hav; auto with zarith.
      * replace (1-1) with 0 by auto with zarith.
        assert(mem .[ shiftfield_F1_list_next bound'] = bound).
        {
          subst bound'.
          replace (x+index) with (Z.succ x + index -1) by auto with zarith.
          eapply Q_array_view_last_next_index_bound; eauto with zarith.
        }
        subst bound; constructor; omega.
Qed.

