(* ---------------------------------------------------------- *)
(* --- Lemma 'index_of_not_in_subrange'                   --- *)
(* ---------------------------------------------------------- *)
Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.

(* --- Global Definitions (continued #1) --- *)
Require Import Memory.

Require Import Axiomatic.
Require Import Compound.

Hypothesis Q_linked_next_index: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((2 <= i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shift_PTR a_1 (1%Z + i_1%Z)%Z) ]) =
   (t_1.[ (shiftfield_F1_list_next a_2) ])).

Hypothesis Q_linked_next_valid: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((2 <= i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((valid_rw t (t_1.[ (shiftfield_F1_list_next a_2) ]) 2%Z)).

Definition P_array_swipe_left (Mptr_0 : farray addr addr)
    (Mptr_1 : farray addr addr) (array_0 : addr) (down_0 : Z) (up_0 : Z)
    : Prop :=
    forall (i : Z), ((down_0 <= i)%Z) -> ((i < up_0)%Z) ->
      ((Mptr_1.[ (shift_PTR array_0 (1%Z + i%Z)%Z) ]) =
       (Mptr_0.[ (shift_PTR array_0 i%Z) ])).

Hypothesis Q_not_in_not_in_swipe_left: forall (i_1 i : Z),
  forall (t_1 t : farray addr addr), forall (a_1 a : addr),
  let x := (i%Z + i_1%Z)%Z in
  ((P_array_swipe_left t_1 t a i_1%Z (i%Z + i_1%Z - 1%Z)%Z)) ->
  (forall (i_2 : Z), ((i_1 < i_2)%Z) -> ((i_2 < x)%Z) ->
   ((separated a_1 1%Z (t.[ (shift_PTR a i_2%Z) ]) 2%Z))) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> (((2 + i_2) <= x)%Z) ->
   ((separated a_1 1%Z (t_1.[ (shift_PTR a i_2%Z) ]) 2%Z))).

Hypothesis Q_linked_root_not_bound_n_sup_zero: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), (a_2 <> a) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) -> ((0 < i)%Z).

Hypothesis Q_linked_zero_root_equal_bound: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((i = 0)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) -> (a_2 = a).

Hypothesis Q_linked_not_empty_head_position: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shift_PTR a_1 i_1%Z) ]) = a_2).

Hypothesis Q_linked_merge_segment_right: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), ((0 <= i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) ->
  ((P_linked_n t t_1 a a_2 (i%Z + i_1%Z)%Z 1%Z a_1)) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)).

Hypothesis Q_linked_merge_segment: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), ((0 <= i)%Z) -> ((0 <= i_1)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) ->
  ((P_linked_n t t_1 a a_2 (i_1%Z + i_2%Z)%Z i%Z a_1)) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)).

Hypothesis Q_linked_split_segment_right_direct: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), let x := (i%Z + i_1%Z)%Z in
  ((t_1.[ (shift_PTR a_2 x) ]) = a) -> ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) /\
   ((P_linked_n t t_1 a a_2 x 1%Z a_1))).

Hypothesis Q_linked_split_segment_right: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_2 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a) ->
  ((0 < i)%Z) -> ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) /\
   ((P_linked_n t t_1 a a_2 (i%Z + i_1%Z)%Z 1%Z a_1))).

Hypothesis Q_linked_split_segment_left: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr),
  let a_3 := t_1.[ (shiftfield_F1_list_next a_2) ] in ((0 < i)%Z) ->
  ((((P_linked_n t t_1 a_2 a_1 i_1%Z 1%Z a_3)) /\
    ((P_linked_n t t_1 a_3 a_1 (1%Z + i_1%Z)%Z (i%Z - 1%Z)%Z a))) <->
   ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a))).

Hypothesis Q_linked_split_segment_direct: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), let x := (i_1%Z + i_2%Z)%Z in
  ((t_1.[ (shift_PTR a_2 x) ]) = a) -> ((0 < i)%Z) -> ((0 < i_1)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) /\
   ((P_linked_n t t_1 a a_2 x i%Z a_1))).

Hypothesis Q_linked_split_segment: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_2 (i_1%Z + i_2%Z - 1%Z)%Z) ])) ]) = a) ->
  ((0 < i_1)%Z) -> ((0 <= i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) /\
   ((P_linked_n t t_1 a a_2 (i_1%Z + i_2%Z)%Z i%Z a_1))).

Hypothesis Q_linked_valid_range: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> ((i_2 < (i + i_1))%Z) ->
   ((valid_rw t (t_1.[ (shift_PTR a_1 i_2%Z) ]) 2%Z))).

Hypothesis Q_linked_max_value_index_n: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (((i + i_1) <= 2147483646)%Z).

Hypothesis Q_linked_n_bounds: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr),
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((((i = 0)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483646)%Z)) \/
   (((0 < i)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483645)%Z))).

Hypothesis Q_linked_last_next_index_bound: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_1 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a).

Hypothesis Q_linked_n_all_elements_not_null: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> ((i_2 < (i + i_1))%Z) ->
   ((t_1.[ (shift_PTR a_1 i_2%Z) ]) <> (null))).

Hypothesis Q_linked_n_starting_from_null_empty: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr), forall (a : addr),
  ((P_linked_n t t_1 (null) a i_1%Z i%Z (null))) -> ((i = 0)%Z).

Require Import S1_list.

Definition P_unchanged (Malloc_0 : array Z) (Mptr_0 : farray addr addr)
    (Mint_0 : farray addr Z) (Malloc_1 : array Z) (Mptr_1 : farray addr addr)
    (Mint_1 : farray addr Z) (array_0 : addr) (down_0 : Z) (up_0 : Z)
    : Prop :=
    forall (i : Z), let a := (shift_PTR array_0 i%Z) in
      let a_1 := Mptr_0.[ a ] in let a_2 := Mptr_1.[ a ] in
      ((down_0 <= i)%Z) -> ((i < up_0)%Z) ->
      ((a_1 = a_2) /\
       ((EqS1_list ((Load_S1_list a_2 Mint_1 Mptr_1))
          ((Load_S1_list a_1 Mint_0 Mptr_0)))) /\
       (((valid_rw Malloc_1 a_2 2%Z)) -> ((valid_rw Malloc_0 a_1 2%Z)))).

Hypothesis Q_stay_linked: forall (i_1 i : Z), forall (t_1 t : array Z),
  forall (t_3 t_2 : farray addr Z), forall (t_5 t_4 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_4 a_2 a_1 i_1%Z i%Z a)) ->
  ((P_unchanged t_1 t_5 t_3 t t_4 t_2 a_1 i_1%Z (i%Z + i_1%Z)%Z)) ->
  ((P_linked_n t_1 t_5 a_2 a_1 i_1%Z i%Z a)).

Require Import A_Index_of_item.

Goal
  forall (i_2 i_1 i : Z),
  forall (t : farray addr addr),
  forall (a_1 a : addr),
  ((0 <= i)%Z) ->
  ((i_2 <= i_1)%Z) ->
  ((0 <= i_2)%Z) ->
  (forall (i_3 : Z), ((i_3 < i_1)%Z) -> ((i_2 <= i_3)%Z) ->
   ((t.[ (shift_PTR a i_3%Z) ]) <> a_1)) ->
  ((((L_index_of t a_1 a i_2%Z i%Z)) = ((L_index_of t a_1 a i_1%Z i%Z)))%Z).

Proof.
  intros down inter up mem item array Hup Hinter Hdown Hneq.
  destruct(Z_lt_ge_dec down up) as [ Hlt1 | Hge1].
  - destruct(Z_lt_ge_dec down inter) as [ Hlt2 | Hge2 ].
    + destruct(Z_lt_ge_dec inter up) as [ Hlt3 | Hge3 ].
      * set(len:=inter-down).
        assert(H: inter = down+len) by (unfold len; omega).
        rewrite H in *.
        clear H. generalize dependent len.
        intros. clear inter.
        assert(Hlen: 0 < len) by omega. clear Hlt2.
        revert Hneq Hdown Hinter Hup Hlt1 Hlt3. revert down.
        apply natlike_ind with (x:=len); try omega.
        -- intros. rewrite Z.add_0_r. reflexivity.
        -- intros len' Hlen' IH down Hneq Hdown Hinter Hup Hlt1 Hlt3.
           replace (Z.succ len') with (len'+1) in * by omega.
           rewrite IH; try omega.
           ++ replace(down+(len'+1)) with (1+(down+len')) by omega.
              rewrite A_Index_of_item.Q_not_the_item; auto; try omega.
              apply Hneq; omega.
           ++ intros; apply Hneq; omega.
      * rewrite A_Index_of_item.Q_no_more_elements with(i_1:=inter); auto; try omega.
        assert(forall i, down <= i -> i < up -> 
               mem .[ shift_PTR array i] <> item) by (intros; apply Hneq; omega).
        clear Hup. assert(Hup: 0 < up) by omega.
        clear Hneq Hinter Hlt2 Hge3 inter.
        set(len:=up-down).
        assert(HH: down = up-len) by (unfold len; omega).
        rewrite HH in *. clear HH. generalize dependent len. 
        intros len Hl Hu Hneq; clear down.
        assert(Hlen: 0 < len) by omega. clear Hu.
        revert Hl Hneq.
        apply natlike_ind with (x:=len); try omega.   
        -- intros. apply A_Index_of_item.Q_no_more_elements; auto; try omega.
        -- intros up' Hup' IH Hl Hitem.
           destruct(Z.eq_dec up' 0) as [ Heq | Hneq ]; subst.
           ++ simpl. 
              rewrite <- A_Index_of_item.Q_not_the_item; try apply Hitem; try omega.
              replace (1 + (up-1)) with up by omega.
              apply A_Index_of_item.Q_no_more_elements; auto; try omega.
           ++ replace(up-Z.succ up') with (up-up'-1) by omega.   
              rewrite <- A_Index_of_item.Q_not_the_item; 
                try apply Hitem; try omega.
              replace (1 + (up - up' - 1)) with (up - up') by omega.
              apply IH; try omega. intros. apply Hitem; omega.
    + assert(down = inter) by omega; now subst. 
  - repeat rewrite A_Index_of_item.Q_no_more_elements; auto; try omega.
Qed.

