(* ---------------------------------------------------------- *)
(* --- Lemma 'linked_merge_segment_right'                 --- *)
(* ---------------------------------------------------------- *)
Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.

(* --- Global Definitions   --- *)
Require Import Memory.

Require Import Compound.

Inductive P_linked_n : array Z -> farray addr addr -> addr -> addr -> Z ->
    Z -> addr -> Prop :=
    | Q_linked_n_bound: forall (i : Z), forall (t : array Z),
        forall (t_1 : farray addr addr), forall (a_1 a : addr),
        ((0 <= i)%Z) -> ((i <= 2147483646)%Z) ->
        ((P_linked_n t t_1 a a_1 i%Z 0%Z a))
    | Q_linked_n_cons: forall (i_1 i : Z), forall (t : array Z),
        forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr),
        let x := (i%Z + i_1%Z)%Z in
        ((t_1.[ (shift_PTR a_1 i_1%Z) ]) = a_2) -> ((0 < i)%Z) ->
        ((0 <= i_1)%Z) -> ((0 <= x)%Z) -> ((x <= 2147483646)%Z) ->
        ((valid_rw t a_2 2%Z)) ->
        ((P_linked_n t t_1 (t_1.[ (shiftfield_F1_list_next a_2) ]) a_1
           (1%Z + i_1%Z)%Z (i%Z - 1%Z)%Z a)) ->
        ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)).

Hypothesis Q_linked_merge_segment: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr), ((0 <= i)%Z) -> ((0 <= i_1)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) ->
  ((P_linked_n t t_1 a a_2 (i_1%Z + i_2%Z)%Z i%Z a_1)) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)).

Hypothesis Q_linked_split_segment_right: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_2 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a) ->
  ((0 < i)%Z) -> ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) /\
   ((P_linked_n t t_1 a a_2 (i%Z + i_1%Z)%Z 1%Z a_1))).

Hypothesis Q_linked_split_segment_left: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr),
  let a_3 := t_1.[ (shiftfield_F1_list_next a_2) ] in ((0 < i)%Z) ->
  ((((P_linked_n t t_1 a_2 a_1 i_1%Z 1%Z a_3)) /\
    ((P_linked_n t t_1 a_3 a_1 (1%Z + i_1%Z)%Z (i%Z - 1%Z)%Z a))) <->
   ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a))).

Hypothesis Q_linked_split_segment: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_2 (i_1%Z + i_2%Z - 1%Z)%Z) ])) ]) = a) ->
  ((0 < i_1)%Z) -> ((0 <= i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) /\
   ((P_linked_n t t_1 a a_2 (i_1%Z + i_2%Z)%Z i%Z a_1))).

Hypothesis Q_linked_valid_range: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> ((i_2 < (i + i_1))%Z) ->
   ((valid_rw t (t_1.[ (shift_PTR a_1 i_2%Z) ]) 2%Z))).

Hypothesis Q_linked_max_value_index_n: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (((i + i_1) <= 2147483646)%Z).

Hypothesis Q_linked_n_bounds: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr),
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((((i = 0)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483646)%Z)) \/
   (((0 < i)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483645)%Z))).

Hypothesis Q_linked_last_next_index_bound: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_1 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a).

Require Import S1_list.

Definition P_unchanged (Malloc_0 : array Z) (Mptr_0 : farray addr addr)
    (Mint_0 : farray addr Z) (Malloc_1 : array Z) (Mptr_1 : farray addr addr)
    (Mint_1 : farray addr Z) (array_0 : addr) (down_0 : Z) (up_0 : Z)
    : Prop :=
    forall (i : Z), let a := (shift_PTR array_0 i%Z) in
      let a_1 := Mptr_0.[ a ] in let a_2 := Mptr_1.[ a ] in
      ((down_0 <= i)%Z) -> ((i < up_0)%Z) ->
      ((a_1 = a_2) /\
       ((EqS1_list ((Load_S1_list a_2 Mint_1 Mptr_1))
          ((Load_S1_list a_1 Mint_0 Mptr_0)))) /\
       (((valid_rw Malloc_1 a_2 2%Z)) -> ((valid_rw Malloc_0 a_1 2%Z)))).

Hypothesis Q_stay_linked: forall (i_1 i : Z), forall (t_1 t : array Z),
  forall (t_3 t_2 : farray addr Z), forall (t_5 t_4 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_4 a_2 a_1 i_1%Z i%Z a)) ->
  ((P_unchanged t_1 t_5 t_3 t t_4 t_2 a_1 i_1%Z (i%Z + i_1%Z)%Z)) ->
  ((P_linked_n t_1 t_5 a_2 a_1 i_1%Z i%Z a)).

Inductive P_wf_finite_separation : farray addr addr -> addr -> Prop :=
    | Q_empty: forall (t : farray addr addr),
        (P_wf_finite_separation t (null))
    | Q_cons: forall (t : farray addr addr), forall (a : addr),
        let a_1 := t.[ (shiftfield_F1_list_next a) ] in ((null) <> a) ->
        ((P_wf_finite_separation t a_1)) -> ((separated a 2%Z a_1 2%Z)) ->
        ((P_wf_finite_separation t a)).

Hypothesis Q_invert_wf_finite_separation_2: forall (t : farray addr addr),
  forall (a : addr), ((null) <> a) -> ((P_wf_finite_separation t a)) ->
  ((separated a 2%Z (t.[ (shiftfield_F1_list_next a) ]) 2%Z)).

Hypothesis Q_invert_wf_finite_separation_1: forall (t : farray addr addr),
  forall (a : addr), ((null) <> a) -> ((P_wf_finite_separation t a)) ->
  ((P_wf_finite_separation t (t.[ (shiftfield_F1_list_next a) ]))).

Goal
  forall (i_1 i : Z),
  forall (t : array Z),
  forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((0 <= i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) ->
  ((P_linked_n t t_1 a a_2 (i%Z + i_1%Z)%Z 1%Z a_1)) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)).

Proof.
  Ltac link := match goal with 
        | [ H : P_linked_n _ _ _ _ _ 1 _ |- _] => 
          inversion H; subst; clear H; try omega
        | [ H : P_linked_n _ _ _ _ _ (1 - 1) _ |- _] => 
          replace (1 - 1) with 0 in * by omega;
          inversion H; subst; clear H; try omega
       | [ H : P_linked_n _ _ _ _ _ _ _ |- _] => 
          inversion H; subst; clear H; try omega
        end.
  intros index n array_i array_a root array bound bound_split Hn Hlinked1.
  induction Hlinked1 as
    [ i array_i array_a root array Hi1 Hi2 |
      i n array_i array_a root array bound0 i' Hroot
      Hn' Hi Hi'1 Hi'2 Hvalid Hlinked IH]; intros Hlinked2.
  - replace (1+0) with 1 by omega.
    constructor; link; auto; try omega.
  - replace (1+(n-1)) with n in * by omega.
    replace (n-1+(1+i)) with (n+i) in * by omega.
    destruct(Z.eq_dec n 1) as [ Heq | Hneq ]; subst.
    + simpl; link; unfold x in * ; constructor; try omega ; auto.
      replace (2-1) with 1 by omega.
      replace (1-1) with 0 in * by omega.
      constructor; try solve [ do 2 link; auto | do 2 link; omega ].
      * replace (1-1) with 0 in * by omega.
        replace (1+i) with (i+1) in * by omega.
        do 2 link. 
        match goal with 
        | [ H: ?x = _ |- context [ ?x ] ] => rewrite H
        end.
        assumption. 
      * replace (1-1) with 0 in * by omega.
        replace (1+i) with (i+1) in * by omega.
        do 2 link. constructor; try omega; auto.
    + constructor; try omega; auto.
      * link; unfold x in * ; omega.
      * replace (1 + n - 1) with n in * by omega.
        apply IH; auto.
        omega.
Qed.

