(* ---------------------------------------------------------- *)
(* --- Lemma 'linked_n_all_elements_not_null'             --- *)
(* ---------------------------------------------------------- *)
Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.

(* --- Global Definitions (continued #1) --- *)
Require Import Memory.

Require Import Axiomatic.

Hypothesis Q_linked_n_starting_from_null_empty: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr), forall (a : addr),
  ((P_linked_n t t_1 (null) a i_1%Z i%Z (null))) -> ((i = 0)%Z).

Require Import Compound.
Require Import S1_list.

Definition P_unchanged (Malloc_0 : array Z) (Mptr_0 : farray addr addr)
    (Mint_0 : farray addr Z) (Malloc_1 : array Z) (Mptr_1 : farray addr addr)
    (Mint_1 : farray addr Z) (array_0 : addr) (down_0 : Z) (up_0 : Z)
    : Prop :=
    forall (i : Z), let a := (shift_PTR array_0 i%Z) in
      let a_1 := Mptr_0.[ a ] in let a_2 := Mptr_1.[ a ] in
      ((down_0 <= i)%Z) -> ((i < up_0)%Z) ->
      ((a_1 = a_2) /\
       ((EqS1_list ((Load_S1_list a_2 Mint_1 Mptr_1))
          ((Load_S1_list a_1 Mint_0 Mptr_0)))) /\
       (((valid_rw Malloc_1 a_2 2%Z)) -> ((valid_rw Malloc_0 a_1 2%Z)))).

Hypothesis Q_stay_linked: forall (i_1 i : Z), forall (t_1 t : array Z),
  forall (t_3 t_2 : farray addr Z), forall (t_5 t_4 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_4 a_2 a_1 i_1%Z i%Z a)) ->
  ((P_unchanged t_1 t_5 t_3 t t_4 t_2 a_1 i_1%Z (i%Z + i_1%Z)%Z)) ->
  ((P_linked_n t_1 t_5 a_2 a_1 i_1%Z i%Z a)).

Goal
  forall (i_1 i : Z),
  forall (t : array Z),
  forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr),
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> ((i_2 < (i + i_1))%Z) ->
   ((t_1.[ (shift_PTR a_1 i_2%Z) ]) <> (null))).

Proof.
  intros i n Mi Ma list array bound Hlin.
  induction Hlin ; intros.
  + omega.
  + destruct (Z.eq_dec i_1 i_2) ; subst.
    - unfold valid_rw in H4.
      intros HF.
      rewrite HF in H4.
      unfold base in H4.
      unfold offset in H4.
      simpl in H4.
      omega.
    - assert (i_2 > i_1). omega.
      apply IHHlin ; omega.
Qed.

