(* ---------------------------------------------------------- *)
(* --- Lemma 'linked_split_segment_direct'                --- *)
(* ---------------------------------------------------------- *)
Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.

(* --- Global Definitions (continued #1) --- *)
Require Import Memory.

Require Import Compound.
Require Import Axiomatic.

Hypothesis Q_linked_split_segment: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_2 (i_1%Z + i_2%Z - 1%Z)%Z) ])) ]) = a) ->
  ((0 < i_1)%Z) -> ((0 <= i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) /\
   ((P_linked_n t t_1 a a_2 (i_1%Z + i_2%Z)%Z i%Z a_1))).

Hypothesis Q_linked_valid_range: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> ((i_2 < (i + i_1))%Z) ->
   ((valid_rw t (t_1.[ (shift_PTR a_1 i_2%Z) ]) 2%Z))).

Hypothesis Q_linked_max_value_index_n: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (((i + i_1) <= 2147483646)%Z).

Hypothesis Q_linked_n_bounds: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr),
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((((i = 0)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483646)%Z)) \/
   (((0 < i)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483645)%Z))).

Hypothesis Q_linked_last_next_index_bound: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_1 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a).

Hypothesis Q_linked_n_all_elements_not_null: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> ((i_2 < (i + i_1))%Z) ->
   ((t_1.[ (shift_PTR a_1 i_2%Z) ]) <> (null))).

Hypothesis Q_linked_n_starting_from_null_empty: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr), forall (a : addr),
  ((P_linked_n t t_1 (null) a i_1%Z i%Z (null))) -> ((i = 0)%Z).

Require Import S1_list.

Definition P_unchanged (Malloc_0 : array Z) (Mptr_0 : farray addr addr)
    (Mint_0 : farray addr Z) (Malloc_1 : array Z) (Mptr_1 : farray addr addr)
    (Mint_1 : farray addr Z) (array_0 : addr) (down_0 : Z) (up_0 : Z)
    : Prop :=
    forall (i : Z), let a := (shift_PTR array_0 i%Z) in
      let a_1 := Mptr_0.[ a ] in let a_2 := Mptr_1.[ a ] in
      ((down_0 <= i)%Z) -> ((i < up_0)%Z) ->
      ((a_1 = a_2) /\
       ((EqS1_list ((Load_S1_list a_2 Mint_1 Mptr_1))
          ((Load_S1_list a_1 Mint_0 Mptr_0)))) /\
       (((valid_rw Malloc_1 a_2 2%Z)) -> ((valid_rw Malloc_0 a_1 2%Z)))).

Hypothesis Q_stay_linked: forall (i_1 i : Z), forall (t_1 t : array Z),
  forall (t_3 t_2 : farray addr Z), forall (t_5 t_4 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_4 a_2 a_1 i_1%Z i%Z a)) ->
  ((P_unchanged t_1 t_5 t_3 t t_4 t_2 a_1 i_1%Z (i%Z + i_1%Z)%Z)) ->
  ((P_linked_n t_1 t_5 a_2 a_1 i_1%Z i%Z a)).

Goal
  forall (i_2 i_1 i : Z),
  forall (t : array Z),
  forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  let x := (i_1%Z + i_2%Z)%Z in
  ((t_1.[ (shift_PTR a_2 x) ]) = a) ->
  ((0 < i)%Z) ->
  ((0 < i_1)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) /\
   ((P_linked_n t t_1 a a_2 x i%Z a_1))).

Proof.
  Ltac u := match goal with 
              [ H :=_ : int |- _ ]=> unfold H; unfold H in *; clear H
             end.
  Ltac norm := repeat match goal with 
   | [ H: context [ 1 - 1 ] |- _ ] => 
      replace (1-1) with (0) in H by omega
    | [ |- context [ 1 - 1 ] ] => 
      replace (1-1) with (0) by omega
    | [ H: context [ ?x - 1 ] |- _ ] => 
      replace (x-1) with (x + (-1)) in H by omega
    | [ |- context [ ?x - 1 ] ] => 
      replace (x-1) with (x+ (-1)) by omega
    | [ H: context [ ?x + 0 ] |- _ ] => 
      replace (x+0) with (x) in H by omega
    | [ |- context [ ?x + 0 ] ] => 
      replace (x+0) with (x) by omega
    | [ H: context [ 0+?x ] |- _ ] => 
      replace (0+x) with (x) in H by omega
    | [ |- context [ 0+?x ] ] => 
      replace (0+x) with (x) by omega
    | [ |- context [ ?x + 1 + (-1) ] ] => 
      replace (x + 1 + (-1)) with (x) by omega
    | [ H: context [?x+ 1 +(-1) ] |- _] => 
      replace (x + 1 + (-1)) with (x) in H by omega
    | [ |- context [ ?x + 2 + (-1) ] ] => 
      replace (x + 2 + (-1)) with (x+1) by omega
    | [ H: context [?x+ 2 +(-1) ] |- _] => 
      replace (x + 2 + (-1)) with (x+1) in H by omega
    | [ H: context [ ?x + 1 + 1 ] |- _ ] => 
      replace (x+1+1) with (x+2) in H by omega
    | [ H: context [ 1 + 1 ] |- _ ] => 
      replace (1+1) with 2 in H by omega
    | [ H: context [ ?x + 1 + 1 ] |- _ ] => 
      replace (x+1+1) with (x+2) in H by omega
    | [ H: context [ ?x + 1 + ?y ] |- _ ] => 
      replace (x+1+y) with (x+y+1) in H by omega
    | [ |- context [ ?x + 1 + ?y ] ] => 
      replace (x+1+y) with (x+y+1) by omega
    | [ H: context [ 1 + ?x ] |- _ ] => 
      replace (1+x) with (x+1) in H by omega
    | [ |- context [ 1 + 1 ] ] => 
      replace (1+1) with 2 by omega
    | [ |- context [ ?x + 1 + 1 ] ] => 
      replace (x+1+1) with (x+2) by omega
    | [ |- context [ 1 + ?x ] ] => 
      replace (1+x) with (x+1) by omega
    | [ H: context [ Z.succ ?x ] |- _ ] => 
      replace (Z.succ x) with (x+1) in H by omega
    | [ |- context [ Z.succ ?x ] ] => 
      replace (Z.succ x) with (x+1) by omega
    end.
  Ltac link := norm; match goal with 
        | [ H : P_linked_n _ _ _ _ _ 1 _ |- _] => 
          inversion H; subst; clear H; try omega
        | [ H : P_linked_n _ _ _ _ _ (1 - 1) _ |- _] => 
          replace (1 - 1) with 0 in * by omega;
          inversion H; subst; clear H; try omega
       | [ H : P_linked_n _ _ _ _ _ _ _ |- _] => 
          inversion H; subst; clear H; try omega
        end.
  intros index size k array_i array_a root array bound bound_split last
         Heq Hn Hk. unfold last in *; clear last.
  revert Heq Hn. revert bound_split root index.
  apply natlike_ind with (x:=size); try omega.
  - intros; split; norm. 
    + link;u;constructor; auto; omega.
    + assert(root = array_a .[ shift_PTR array index]) by now link.
      subst. auto.
  - intros x Hx IH bound_split root index Heq HSx Hlinked.
    link; u; norm.
    destruct(Z.eq_dec x 0) as [ Heq | Hneq ]; subst;norm.
    + split.
      * constructor; try omega; auto; norm. link.
        rewrite <- H; constructor; try omega; auto.
      * assert(HH:(array_a .[ shiftfield_F1_list_next (array_a .[ shift_PTR array index])]) =
                  (array_a .[ shift_PTR array (index + 1)])) by now link.
        now rewrite <- HH. 
    + assert(H'x: 0<k) by omega. norm.
      set(bound0 := array_a .[ (array_a .[ shift_PTR array (x + index + 1)])]).
      replace (k + (x + 1) + -1) with (k + x) in H5 by omega.
      specialize(IH _ _ _ eq_refl H'x H5).
      destruct IH as [ IH1 IH2 ]; split; norm.
      * constructor; auto; try omega; norm; rewrite <- Z.add_assoc; auto.
      * now rewrite <- Z.add_assoc.
Qed.

