(* ---------------------------------------------------------- *)
(* --- Lemma 'linked_split_segment_right'                 --- *)
(* ---------------------------------------------------------- *)
Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.

(* --- Global Definitions   --- *)
Require Import Memory.

Require Import Compound.

Inductive P_linked_n : array Z -> farray addr addr -> addr -> addr -> Z ->
    Z -> addr -> Prop :=
    | Q_linked_n_bound: forall (i : Z), forall (t : array Z),
        forall (t_1 : farray addr addr), forall (a_1 a : addr),
        ((0 <= i)%Z) -> ((i <= 2147483646)%Z) ->
        ((P_linked_n t t_1 a a_1 i%Z 0%Z a))
    | Q_linked_n_cons: forall (i_1 i : Z), forall (t : array Z),
        forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr),
        let x := (i%Z + i_1%Z)%Z in
        ((t_1.[ (shift_PTR a_1 i_1%Z) ]) = a_2) -> ((0 < i)%Z) ->
        ((0 <= i_1)%Z) -> ((0 <= x)%Z) -> ((x <= 2147483646)%Z) ->
        ((valid_rw t a_2 2%Z)) ->
        ((P_linked_n t t_1 (t_1.[ (shiftfield_F1_list_next a_2) ]) a_1
           (1%Z + i_1%Z)%Z (i%Z - 1%Z)%Z a)) ->
        ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)).

Hypothesis Q_linked_split_segment_left: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr),
  let a_3 := t_1.[ (shiftfield_F1_list_next a_2) ] in ((0 < i)%Z) ->
  ((((P_linked_n t t_1 a_2 a_1 i_1%Z 1%Z a_3)) /\
    ((P_linked_n t t_1 a_3 a_1 (1%Z + i_1%Z)%Z (i%Z - 1%Z)%Z a))) <->
   ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a))).

Hypothesis Q_linked_split_segment: forall (i_2 i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_2 (i_1%Z + i_2%Z - 1%Z)%Z) ])) ]) = a) ->
  ((0 < i_1)%Z) -> ((0 <= i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_2%Z (i%Z + i_1%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_2%Z i_1%Z a)) /\
   ((P_linked_n t t_1 a a_2 (i_1%Z + i_2%Z)%Z i%Z a_1))).

Hypothesis Q_linked_valid_range: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (forall (i_2 : Z), ((i_1 <= i_2)%Z) -> ((i_2 < (i + i_1))%Z) ->
   ((valid_rw t (t_1.[ (shift_PTR a_1 i_2%Z) ]) 2%Z))).

Hypothesis Q_linked_max_value_index_n: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  (((i + i_1) <= 2147483646)%Z).

Hypothesis Q_linked_n_bounds: forall (i_1 i : Z), forall (t : array Z),
  forall (t_1 : farray addr addr), forall (a_2 a_1 a : addr),
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((((i = 0)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483646)%Z)) \/
   (((0 < i)%Z) /\ ((0 <= i_1)%Z) /\ ((i_1 <= 2147483645)%Z))).

Hypothesis Q_linked_last_next_index_bound: forall (i_1 i : Z),
  forall (t : array Z), forall (t_1 : farray addr addr),
  forall (a_2 a_1 a : addr), ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_2 a_1 i_1%Z i%Z a)) ->
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_1 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a).

Require Import S1_list.

Definition P_unchanged (Malloc_0 : array Z) (Mptr_0 : farray addr addr)
    (Mint_0 : farray addr Z) (Malloc_1 : array Z) (Mptr_1 : farray addr addr)
    (Mint_1 : farray addr Z) (array_0 : addr) (down_0 : Z) (up_0 : Z)
    : Prop :=
    forall (i : Z), let a := (shift_PTR array_0 i%Z) in
      let a_1 := Mptr_0.[ a ] in let a_2 := Mptr_1.[ a ] in
      ((down_0 <= i)%Z) -> ((i < up_0)%Z) ->
      ((a_1 = a_2) /\
       ((EqS1_list ((Load_S1_list a_2 Mint_1 Mptr_1))
          ((Load_S1_list a_1 Mint_0 Mptr_0)))) /\
       (((valid_rw Malloc_1 a_2 2%Z)) -> ((valid_rw Malloc_0 a_1 2%Z)))).

Hypothesis Q_stay_linked: forall (i_1 i : Z), forall (t_1 t : array Z),
  forall (t_3 t_2 : farray addr Z), forall (t_5 t_4 : farray addr addr),
  forall (a_2 a_1 a : addr), ((P_linked_n t t_4 a_2 a_1 i_1%Z i%Z a)) ->
  ((P_unchanged t_1 t_5 t_3 t t_4 t_2 a_1 i_1%Z (i%Z + i_1%Z)%Z)) ->
  ((P_linked_n t_1 t_5 a_2 a_1 i_1%Z i%Z a)).

Inductive P_wf_finite_separation : farray addr addr -> addr -> Prop :=
    | Q_empty: forall (t : farray addr addr),
        (P_wf_finite_separation t (null))
    | Q_cons: forall (t : farray addr addr), forall (a : addr),
        let a_1 := t.[ (shiftfield_F1_list_next a) ] in ((null) <> a) ->
        ((P_wf_finite_separation t a_1)) -> ((separated a 2%Z a_1 2%Z)) ->
        ((P_wf_finite_separation t a)).

Hypothesis Q_invert_wf_finite_separation_2: forall (t : farray addr addr),
  forall (a : addr), ((null) <> a) -> ((P_wf_finite_separation t a)) ->
  ((separated a 2%Z (t.[ (shiftfield_F1_list_next a) ]) 2%Z)).

Hypothesis Q_invert_wf_finite_separation_1: forall (t : farray addr addr),
  forall (a : addr), ((null) <> a) -> ((P_wf_finite_separation t a)) ->
  ((P_wf_finite_separation t (t.[ (shiftfield_F1_list_next a) ]))).

Goal
  forall (i_1 i : Z),
  forall (t : array Z),
  forall (t_1 : farray addr addr),
  forall (a_3 a_2 a_1 a : addr),
  ((t_1.[ (shiftfield_F1_list_next
            (t_1.[ (shift_PTR a_2 (i%Z + i_1%Z - 1%Z)%Z) ])) ]) = a) ->
  ((0 < i)%Z) ->
  ((P_linked_n t t_1 a_3 a_2 i_1%Z (1%Z + i%Z)%Z a_1)) ->
  (((P_linked_n t t_1 a_3 a_2 i_1%Z i%Z a)) /\
   ((P_linked_n t t_1 a a_2 (i%Z + i_1%Z)%Z 1%Z a_1))).

Proof.
  Ltac u := match goal with 
              [ H :=_ : int |- _ ]=> unfold H; unfold H in *; clear H
             end.
  Ltac norm := repeat match goal with 
   | [ H: context [ 1 - 1 ] |- _ ] => 
      replace (1-1) with (0) in H by omega
    | [ |- context [ 1 - 1 ] ] => 
      replace (1-1) with (0) by omega
    | [ H: context [ ?x - 1 ] |- _ ] => 
      replace (x-1) with (x + (-1)) in H by omega
    | [ |- context [ ?x - 1 ] ] => 
      replace (x-1) with (x+ (-1)) by omega
    | [ H: context [ ?x + 0 ] |- _ ] => 
      replace (x+0) with (x) in H by omega
    | [ |- context [ ?x + 0 ] ] => 
      replace (x+0) with (x) by omega
    | [ H: context [ 0+?x ] |- _ ] => 
      replace (0+x) with (x) in H by omega
    | [ |- context [ 0+?x ] ] => 
      replace (0+x) with (x) by omega
    | [ |- context [ ?x + 1 + (-1) ] ] => 
      replace (x + 1 + (-1)) with (x) by omega
    | [ H: context [?x+ 1 +(-1) ] |- _] => 
      replace (x + 1 + (-1)) with (x) in H by omega
    | [ |- context [ ?x + 2 + (-1) ] ] => 
      replace (x + 2 + (-1)) with (x+1) by omega
    | [ H: context [?x+ 2 +(-1) ] |- _] => 
      replace (x + 2 + (-1)) with (x+1) in H by omega
    | [ H: context [ ?x + 1 + 1 ] |- _ ] => 
      replace (x+1+1) with (x+2) in H by omega
    | [ H: context [ 1 + 1 ] |- _ ] => 
      replace (1+1) with 2 in H by omega
    | [ H: context [ ?x + 1 + 1 ] |- _ ] => 
      replace (x+1+1) with (x+2) in H by omega
    | [ H: context [ ?x + 1 + ?y ] |- _ ] => 
      replace (x+1+y) with (x+y+1) in H by omega
    | [ |- context [ ?x + 1 + ?y ] ] => 
      replace (x+1+y) with (x+y+1) by omega
    | [ H: context [ 1 + ?x ] |- _ ] => 
      replace (1+x) with (x+1) in H by omega
    | [ |- context [ 1 + 1 ] ] => 
      replace (1+1) with 2 by omega
    | [ |- context [ ?x + 1 + 1 ] ] => 
      replace (x+1+1) with (x+2) by omega
    | [ |- context [ 1 + ?x ] ] => 
      replace (1+x) with (x+1) by omega
    | [ H: context [ Z.succ ?x ] |- _ ] => 
      replace (Z.succ x) with (x+1) in H by omega
    | [ |- context [ Z.succ ?x ] ] => 
      replace (Z.succ x) with (x+1) by omega
    end.
  Ltac link := norm; match goal with 
        | [ H : P_linked_n _ _ _ _ _ 1 _ |- _] => 
          inversion H; subst; clear H; try omega
        | [ H : P_linked_n _ _ _ _ _ (1 - 1) _ |- _] => 
          replace (1 - 1) with 0 in * by omega;
          inversion H; subst; clear H; try omega
       | [ H : P_linked_n _ _ _ _ _ _ _ |- _] => 
          inversion H; subst; clear H; try omega
        end.
  intros index n array_i array_a root array bound bound_split
         Heq Hn.
  assert(0<=n) by omega. revert Heq Hn. revert bound_split root index.
  apply natlike_ind with (x:=n); try omega.
  - intros; omega.
  - intros x Hx IH bound_split root index Heq HSx Hlinked.
    link; u; norm.
    destruct(Z.eq_dec x 0) as [ Heq | Hneq ]; subst;norm.
    + repeat link; split; 
      repeat(constructor; try omega; auto; norm).
    + assert(H'x: 0<x) by omega.
      set(bound0 := array_a .[ shiftfield_F1_list_next
      (array_a .[ shift_PTR array (x + index)])]).
      assert(Hb: array_a .[ shiftfield_F1_list_next
      (array_a .[ shift_PTR array (x + (index + 1) - 1)])] = bound0)
        by (unfold bound0; do 4 f_equal; omega).
      specialize(IH _ _ _ Hb H'x H6). 
      destruct IH as [ IH1 IH2 ]; split; norm.
      * constructor; norm; auto; omega.
      * now rewrite <- Z.add_assoc.
Qed.

