(* ---------------------------------------------------------- *)
(* --- Lemma 'stay_linked'                                --- *)
(* ---------------------------------------------------------- *)
Require Import ZArith.
Require Import Reals.
Require Import BuiltIn.
Require Import int.Int.
Require Import int.Abs.
Require Import int.ComputerDivision.
Require Import real.Real.
Require Import real.RealInfix.
Require Import real.FromInt.
Require Import map.Map.
Require Import Qedlib.
Require Import Qed.

(* --- Global Definitions (continued #1) --- *)
Require Import Memory.

Require Import Axiomatic.
Require Import Compound.
Require Import S1_list.

Definition P_unchanged (Malloc_0 : array Z) (Mptr_0 : farray addr addr)
    (Mint_0 : farray addr Z) (Malloc_1 : array Z) (Mptr_1 : farray addr addr)
    (Mint_1 : farray addr Z) (array_0 : addr) (down_0 : Z) (up_0 : Z)
    : Prop :=
    forall (i : Z), let a := (shift_PTR array_0 i%Z) in
      let a_1 := Mptr_0.[ a ] in let a_2 := Mptr_1.[ a ] in
      ((down_0 <= i)%Z) -> ((i < up_0)%Z) ->
      ((a_1 = a_2) /\
       ((EqS1_list ((Load_S1_list a_2 Mint_1 Mptr_1))
          ((Load_S1_list a_1 Mint_0 Mptr_0)))) /\
       (((valid_rw Malloc_1 a_2 2%Z)) -> ((valid_rw Malloc_0 a_1 2%Z)))).

Goal
  forall (i_1 i : Z),
  forall (t_1 t : array Z),
  forall (t_3 t_2 : farray addr Z),
  forall (t_5 t_4 : farray addr addr),
  forall (a_2 a_1 a : addr),
  ((P_linked_n t t_4 a_2 a_1 i_1%Z i%Z a)) ->
  ((P_unchanged t_1 t_5 t_3 t t_4 t_2 a_1 i_1%Z (i%Z + i_1%Z)%Z)) ->
  ((P_linked_n t_1 t_5 a_2 a_1 i_1%Z i%Z a)).

Proof.
  Ltac apply_Heq := 
    match goal with 
    | [ Heq: forall _ : int, _ -> _ ->  _|- _ ] => subst; apply Heq; omega
    end. 
  Ltac destruct_and := 
    repeat match goal with [ H : _ /\ _ |- _ ]=> destruct H end.
  Ltac specialize_Heq := 
    match goal with 
      | [ Heq: forall _ : int, ?i <= _ -> _ < ?i' + _ ->  _|- _ ] => 
        let Heq' := fresh "Heq" in set(Heq':=Heq);
        let H := fresh "H" in assert(H: i < i' + i) by omega;
        specialize(Heq' i (Z.le_refl i) H);
        destruct_and
    end.
  Ltac rewrite_array := 
    match goal with 
      [ H: _ .[ _ ] = _ .[ _ ] |- _ ] => rewrite <- H
    end.
  unfold P_unchanged; intros. 
  match goal with 
    [ H : P_linked_n _ _ _ _ _ _ _  |- _] => induction H
  end.
  - constructor; omega.
  - constructor; auto.
    + apply_Heq.
    + subst. specialize_Heq.
      rewrite_array.
      auto.
    + specialize_Heq.
      match goal with 
      [ H : ?Ma' .[ _ ] = ?Ma .[ _ ] |-
        P_linked_n _ ?Ma' (?Ma' .[ ?OP ?root ]) ?array (1 + ?i) _ _ ] =>
        let HH := fresh "HH" in 
        assert(HH: Ma' .[ OP root ] = Ma .[ OP root ])
          by(subst; rewrite <- H at 1; apply_Heq);
        rewrite HH
      end.
      apply IHP_linked_n.
      intros; apply_Heq.
Qed.

