#ifndef _LIST_H_
#define _LIST_H_

#define INT_MAX 2147483647
#define MAX_SIZE INT_MAX-1
#define NULL ((void*) 0)

struct list {
  struct list *next;
  int k;
};

typedef struct list ** list_t ;

void
list_init(   list_t list,
/* ghost: */ struct list **array);

struct list *
list_head(   list_t list,
/* ghost: */ struct list **array, int index, int n);

struct list *
list_tail(   list_t list,
/* ghost: */ struct list **array, int index, int n);

struct list *
list_pop(    list_t list,
/* ghost: */ struct list **array, int index, int n);

void
list_push(   list_t list, struct list *item,
/* ghost: */ struct list **array, int index, int n, int item_idx);

int
list_length( list_t list,
/* ghost: */ struct list **array, int index, int n);

struct list *
list_chop(list_t list,
/* ghost: */ struct list **array, int index, int n);

void
list_add(    list_t list, struct list *item,
/* ghost: */ struct list **array, int index, int n, int item_idx);

void
list_remove( list_t list, struct list *item,
/* ghost: */ struct list **array, int index, int n, int item_idx);

void
list_copy(   list_t dest, list_t src,
/* ghost: */ struct list **array, int index, int n);

void
list_insert( list_t list, struct list *previtem, struct list *newitem,
/* ghost: */ struct list **array, int index, int n, struct list *bound);

struct list *
list_item_next(struct list *item,
/* ghost: */   struct list **array, int index, int n);

#endif
