#ifdef _IN_LIST_MAIN_FILE

/*@
  requires \valid(list) && \valid(end) && \valid(item) ;
  requires \separated(list, end, item);
  requires ValidArray : \valid(array + (0 .. MAX_SIZE-1));
  requires 0 < index+n < MAX_SIZE ;
  requires Linked_1 : linked_n (*list, array, index, n-1, end);
  requires Linked_2 : linked_n (end, array, index+n-1, 1, end->next);
  requires item_value: item->next == NULL ;

  requires GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  requires GhostSeparation: \separated(list, *(array + (index .. index + n - 1))) ;
  requires GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  requires \separated(item, array + (0 .. MAX_SIZE - 1)) ;
  requires Item_Separation:
    \forall integer i ; index <= i < index + n ==> \separated(item, array[i]);  

  requires Separation: 
    \forall integer y ; 
      index <= y < index + n ==> 
        \separated( * (array + y), array + (0 .. MAX_SIZE - 1));
  requires Separation : 
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && z != y ==> 
        \separated( * (array + y), * (array + z) );
  requires Unique : 
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && z != y ==> 
        array[z] != array[y] ;

  assigns end->next, array[index+n] ;

  ensures linked_n(*list, array, index, n+1, NULL);
  ensures unchanged{Pre,Post}(array, index, index + n - 1) ;
  ensures array[index+n-1] == \old(array[index+n-1]) ;
  ensures array[index+n] == item ;

  ensures GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  ensures GhostSeparation: \separated(list, *(array + (index .. index + n))) ;
  ensures GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  ensures \separated(item, array + (0 .. MAX_SIZE - 1)) ;
  ensures Separation: 
    \forall integer y ; 
      index <= y < index + n + 1 ==> 
        \separated( * (array + y), array + (0 .. MAX_SIZE - 1));
  ensures Separation : 
    \forall integer y, z; 
      index <= y < index + n + 1 && index <= z < index + n + 1 && z != y ==> 
        \separated( * (array + y), * (array + z) );
  ensures Unique : 
    \forall integer y, z; 
      index <= y < index + n + 1 && index <= z < index + n + 1 && z != y ==> 
        array[z] != array[y] ;
*/
static inline void
list_final_add(list_t list, struct list* end, struct list *item,
  /* ghost: */ struct list **array, int index, int n){
  //@ ghost array[index+n] = item ;
  
  
  end->next = item ;

  

}

/*@
  requires \valid( list ) && \valid(item) ;
  requires \separated(list, item) ;
  requires Linked : linked_n (*list, array, index, n, NULL);
  requires ValidArray : \valid(array + (0 .. MAX_SIZE-1));
  requires 0 <= index < MAX_SIZE && 0 <= n < MAX_SIZE ;
  requires index+n < MAX_SIZE ;

  requires GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  requires GhostSeparation: \separated(list, *(array + (index .. index + n - 1))) ;
  requires GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  requires \separated(item, array + (0 .. MAX_SIZE - 1)) ;
  requires Item_Separation:
    \forall integer i ; index <= i < index + n ==> 
      item != array[i] ==> \separated(item, array[i]);  

  requires Separation: 
    \forall integer y ; 
      index <= y < index + n ==> 
        \separated( * (array + y), array + (0 .. MAX_SIZE - 1));
  requires Separation : 
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && z != y ==> 
        \separated( * (array + y), * (array + z) );
  requires Unique : 
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && z != y ==> 
        array[z] != array[y] ;

  requires item_idx == index_of(item, array, index, index+n) ;

  assigns array[item_idx .. index+n-1], array[item_idx - 1]->next, *list,
          array[index + n - 1]->next, array[index + n - 2]->next,
	  array[index + n], array[index + n - 1],
	  item->next ;

  ensures GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  ensures GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  behavior contains_item:
    assumes \exists integer i ; index <= i < index+n && array[i] == item ;
    ensures linked_n(*list, array, index, n, NULL);
    ensures unchanged{Pre,Post}(array, index, item_idx - 1);
    ensures array_swipe_left{Pre,Post}(array, item_idx, index + n - 1);
    ensures array[index+n-1] == item ;
    ensures item_idx > index ==> array[item_idx-1] == \old(array[item_idx-1]) ;

    ensures GhostSeparation: \separated(list, *(array + (index .. index + n - 1))) ;

    ensures Separation : 
      \forall integer y ; index <= y < index + n ==> 
          \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

    ensures Separation : 
      \forall integer y, z; 
        index <= y < index + n && index <= z < index + n && z != y ==> 
          \separated( * (array + y), * (array + z) );

    ensures Unique:
      \forall integer y, z; 
        index <= y < index + n && index <= z < index + n && z != y ==> 
          array[z] != array[y] ;

  behavior does_not_contain_item:
    assumes \forall integer i ; index <= i < index+n ==> array[i] != item ;
    ensures linked_n(*list, array, index, n+1, NULL);
    ensures unchanged{Pre,Post}(array, index, index + n - 1);
    ensures End: n > 0 ==> array[index+n-1] == \old(array[index+n-1]);
    ensures array[index+n] == item ;

    ensures GhostSeparation: \separated(list, *(array + (index .. index + n))) ;

    ensures Separation : 
      \forall integer y ; index <= y < index + n + 1 ==> 
          \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

    ensures Separation : 
      \forall integer y, z; 
        index <= y < index + n + 1 && index <= z < index + n + 1 && z != y ==> 
          \separated( * (array + y), * (array + z) );

    ensures Unique:
      \forall integer y, z; 
        index <= y < index + n + 1 && index <= z < index + n + 1 && z != y ==> 
          array[z] != array[y] ;

  complete behaviors ;
  disjoint behaviors ;
*/
void
list_add(    list_t list, struct list *item,
	     /* ghost: */ struct list **array, int index, int n, int item_idx)
{
  struct list *l;
  //@ ghost int new_n = item_idx == index+n ? n : n-1 ;

  /*@ ghost 
    index_of_bounds_weak(item, array, index, index+n);
    if(new_n == n) index_of_up_unexisting_item(item, array, index, index+n);
    else           index_of_inter_existing_item(item, array, index, index+n);
  */
  
  
  /* Make sure not to add the same element twice */
  list_remove(list, item, /* ghost: */ array, index, n, item_idx);

  //@ ghost L1: ;
  ((struct list *)item)->next = NULL;
  //@ ghost L1P: ;
  

  
  // NEW CODE
  
  if(*list == NULL) {
    *list = item ;
    //@ ghost array[index] = item ;

  } else {
    l = list_tail(list, /* ghost: */ array, index, new_n);

    //@ ghost L2: ;


    list_final_add(list, l, item, /* ghost */ array, index, new_n);

      }
}

#endif
