#ifdef _IN_LIST_MAIN_FILE

/*@
  requires \valid(list);
  requires \valid(array + (0 .. MAX_SIZE - 1));
  requires linked_n(*list, array, index, size, NULL);
  
  requires GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  requires GhostSeparation: \separated(list, *(array + (index .. index + size - 1))) ;
  requires GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  requires Separation : 
    \forall integer y ; 
      index <= y < index + size ==> 
        \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

  requires Separation:
    \forall integer y, z; 
      index <= y < index + size && index <= z < index + size && y != z ==> 
        \separated(* (array+y), *(array+z));

  requires Unique:
    \forall integer y, z; 
      index <= y < index + size && index <= z < index + size && y != z ==> 
        array[y] != array[z];

  assigns *list, array[index+size-2]->next ;
  
  ensures GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  ensures GhostSeparation: \separated(list, *(array + (index .. index + size - 1))) ;
  ensures GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  ensures unchanged{Pre, Here}(array, index, index + size - 2);

  ensures Separation : 
    \forall integer y ; 
      index <= y < index + size - 1 ==> 
        \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

  ensures Separation:
    \forall integer y, z; 
      index <= y < index + size - 1 && index <= z < index + size - 1 && y != z ==> 
        \separated(* (array+y), *(array+z));

  ensures Unique:
    \forall integer y, z; 
      index <= y < index + size - 1 && index <= z < index + size - 1 && y != z ==> 
        array[y] != array[z];

  behavior empty:
    assumes size == 0;
    ensures \result == NULL;
    ensures *list == \old(*list);

  behavior one:
    assumes size == 1;
    ensures \result == array[index];
    ensures *list == NULL ; 
    ensures linked_n(*list, array, index, 0, NULL);
    
  behavior more:
    assumes size > 1;
    ensures \result == array[index+size-1];
    ensures array[index+size-2]->next == NULL;
    ensures linked_n(*list, array, index, size-1, NULL);
    ensures *list == \old(*list);
     
  disjoint behaviors;
  complete behaviors;
*/

struct list *
list_chop(   list_t list,
/* ghost: */ struct list **array, int index, int size)
{
  struct list *l, *r;

  if(*list == NULL) {
    
    return NULL;
  }
  if(((struct list *)*list)->next == NULL) {
    
    l = *list;
    *list = NULL;
    
    
    return l;
  }

  
  /* ghost */ int i = 0;
  l = *list;

  /*@ 
    loop invariant \valid(l->next);
    loop invariant size - i > 1;
    loop invariant linked_n(l, array, index+i, size-i, NULL);
    loop invariant l == array[index+i];
    loop assigns   l, i; 
    loop variant   size-i;
  */
  while (l->next->next != NULL){
    l = l->next;
    /*ghost*/i++;
  }
  
  r = l->next;
  

 RemoveLast:
  l->next = NULL;
  
  //@ ghost  linked_n_merge_segment(*list, NULL, array, index, size-2, array[index+size-2], 1);

  return r;
}

#endif
