#ifdef _IN_LIST_MAIN_FILE

/*@
  requires \valid(list);
  requires linked_n(*list, array, index, n, NULL);
  
  assigns \nothing;

  ensures \result == n ;
*/
int
list_length( list_t list,
/* ghost: */ struct list **array, int index, int n)
{
  struct list *l;
  int length = 0;

  /*@
    loop invariant index <= index + length <= index + n ;
    loop invariant linked_n(l, array, index+length, n-length, NULL);
    loop assigns length, l ;
    loop variant n - length ;
  */
  for(l = *list; l != NULL; l = l->next) {
    ++length;
  }

  return length;
}

#endif
