#ifdef _IN_LIST_MAIN_FILE

/*@
  requires \valid(list);
  requires Linked : linked_n (*list, array, index, n, NULL);
  requires ValidArray : \valid( array + (0 .. MAX_SIZE - 1) );
  requires 0 <= index ;

  requires GhostSeparation:
    \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  requires 
    \separated(list, *(array + (index .. index + n - 1))) ;
  requires 
    \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  requires Separation:
    \forall integer y ; 
      index <= y < index + n ==> 
        \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

  requires Separation:
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && y != z ==> 
        \separated(* (array+y), *(array+z));

  requires Unique:
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && y != z ==> 
        array[y] != array[z];

  ensures \result == \at(*list, Pre);

  ensures GhostSeparation:
    \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  ensures 
    \separated(list, *(array + (index .. index + n - 1))) ;
  ensures 
    \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  behavior empty :
    assumes n == 0;

    ensures *list == \at(*list, Pre);
    ensures linked_n (*list, array, index, n, NULL);
    ensures unchanged{Pre, Post} (array, index, index + n);
    ensures \result == \null;

    ensures Unique:
      \forall integer y, z; 
        index <= y < index + n && index <= z < index + n && y != z ==> 
          array[y] != array[z];

    ensures Separation:
      \forall integer y ; 
        index <= y < index + n ==> 
          \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

    ensures Separation:
      \forall integer y, z; 
        index <= y < index + n && index <= z < index + n && y != z ==> 
          \separated(* (array+y), *(array+z));
    
    assigns \nothing;


  behavior more:
    assumes n >= 1;

    ensures *list == \at((*list)->next, Pre);
    ensures array_swipe_left{Pre, Post} (array, index, index + n - 1);
    ensures linked_n (*list, array, index, n - 1, NULL);
    
    ensures Unique:
      \forall integer y, z; 
        index <= y < index + n - 1 && index <= z < index + n - 1 && y != z ==> 
          array[y] != array[z];

    ensures Separation : 
      \forall integer y; 
        index <= y < index + n - 1 ==> 
          \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

    ensures Separation:
      \forall integer y, z; 
        index <= y < index + n - 1 && index <= z < index + n - 1 && y != z ==> 
          \separated(* (array+y), *(array+z));

    ensures NoMoreHere:
      \forall integer x ; index <= x < index+n-1 ==> array[x] != \result ;

    ensures NoMoreHere:
      \forall integer x ; index <= x < index+n-1 ==> \separated(array[x], \result);


    assigns *list, array[index .. index + n-2];
        
  complete behaviors;
  disjoint behaviors;
*/
struct list *
list_pop(    list_t list,
/* ghost: */ struct list **array, int index, int n)
{
  struct list *l;
  l = *list;
  if(*list != NULL) {
    //@ ghost struct list *next = (*list)->next ;
    //@ ghost array_pop(array, index, n, list, *list, NULL, index);

    //@ ghost if(n-1 != 0) linked_n_all_elements(next, NULL, array, index, n - 1) ;
    //@ ghost Rest: ;
    *list = ((struct list *)*list)->next;
  }
  return l;
}

#endif
