#ifdef _IN_LIST_MAIN_FILE

/*@
  requires \valid( list ) && \valid(item) ;
  requires \separated(list, item) ;
  requires Linked : linked_n (*list, array, index, n, NULL);
  requires ValidArray : \valid(array + (0 .. MAX_SIZE-1));
  requires 0 <= index && 0 <= n < MAX_SIZE ;
  requires EnoughSpace : index + n + 1 <= MAX_SIZE; 

  requires GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  requires GhostSeparation: \separated(list, *(array + (index .. index + n - 1))) ;
  requires GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  requires \separated(item, array + (0 .. MAX_SIZE - 1)) ;
  requires Item_Separation:
    \forall integer i ; index <= i < index + n ==> 
      item != array[i] ==> \separated(item, array[i]);

  requires Separation: 
    \forall integer y ; 
      index <= y < index + n ==> 
        \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

  requires Separation : 
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && y != z ==> 
        \separated( * (array + y), * (array + z) );

  requires Unique:
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && y != z ==> 
        array[y] != array[z];

  requires item_idx == index_of(item, array, index, index+n) ;

  assigns array[index .. index + n], array[item_idx - 1]->next, 
          item->next, *list ;

  ensures GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  ensures GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  behavior contains_item:
    assumes \exists integer i ; index <= i < index+n && array[i] == item ;
    ensures linked_n(*list, array, index, n, NULL);
    ensures unchanged{Pre,Post}(array, item_idx + 1, index+n);
    ensures array_swipe_right{Pre, Post}(array, index + 1, item_idx + 1);
    ensures array[index] == item ;

    ensures GhostSeparation: \separated(list, *(array + (index .. index + n - 1))) ;

    ensures Separation : 
      \forall integer y ; index <= y < index + n  ==> 
          \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

    ensures Separation : 
      \forall integer y, z; 
        index <= y < index + n && index <= z < index + n && y != z ==> 
          \separated( * (array + y), * (array + z) );

    ensures Unique:
      \forall integer y, z; 
        index <= y < index + n && index <= z < index + n && y != z ==> 
          array[y] != array[z];

  behavior does_not_contain_item:
    assumes \forall integer i ; index <= i < index+n ==> array[i] != item ;
    ensures linked_n(*list, array, index, n+1, NULL);
    ensures array_swipe_right{Pre, Post}(array, index + 1, index + n + 1);
    ensures array[index] == item ;

    ensures GhostSeparation: \separated(list, *(array + (index .. index + n))) ;

    ensures Separation : 
      \forall integer y ; index <= y < index + n + 1 ==> 
          \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

    ensures Separation : 
      \forall integer y, z; 
        index <= y < index + n + 1 && index <= z < index + n + 1 && y != z ==> 
          \separated( * (array + y), * (array + z) );

    ensures Unique:
      \forall integer y, z; 
        index <= y < index + n + 1 && index <= z < index + n + 1 && y != z ==> 
          array[y] != array[z];
  
  complete behaviors ;
  disjoint behaviors ;
*/
void
list_push(   list_t list, struct list *item,
	     /* ghost: */ struct list **array, int index, int n, int item_idx)
{
  struct list *l;
  //@ ghost int new_n = item_idx == index+n ? n : n-1 ;

  /*@ ghost 
    index_of_bounds_weak(item, array, index, index+n);
    if(new_n == n) index_of_up_unexisting_item(item, array, index, index+n);
    else           index_of_inter_existing_item(item, array, index, index+n);
  */
  
  
  /* Make sure not to add the same element twice */
  list_remove(list, item, /*ghost:*/ array, index, n, item_idx);

  //@ ghost AfterR: ;

  

  //@ ghost int new_index = index + 1 ;
  //@ ghost array_push(array, index, new_n, list, *list, NULL);
  //@ ghost AfterP: ;
  





  
  ((struct list *)item)->next = *list;

  //@ ghost array[index] = item ;



  //@ ghost BeforeLastInstr : ;

  
  *list = item;
  //@ ghost AfterLastInstr : ;
  
  /*@ assigns \nothing ;
    ensures unchanged{BeforeLastInstr, AfterLastInstr}(array, index, new_index + new_n) ;
   */ {
  }

}

#endif
