#ifdef _IN_LIST_MAIN_FILE

/*@
  requires \valid( list ) && item != \null ;
  requires Linked : linked_n (*list, array, index, n, NULL);
  requires ValidArray : \valid(array + (0 .. MAX_SIZE-1));
  requires 0 <= index && 0 <= n < MAX_SIZE ;

  requires GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  requires GhostSeparation: \separated(list, *(array + (index .. index + n - 1))) ;
  requires GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;
  
  requires Item_Separation:
    \forall integer i ; index <= i < index + n ==> 
      item != array[i] ==> \separated(item, array[i]);

  requires Separation : 
    \forall integer y ; 
      index <= y < index + n ==> 
        \separated( * (array + y), array + (0 .. MAX_SIZE - 1));

  requires Separation : 
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && y != z ==> 
        \separated(* (array + y), * (array + z));

  requires Unique:
    \forall integer y, z; 
      index <= y < index + n && index <= z < index + n && y != z ==> 
        array[y] != array[z];

  requires item_idx == index_of(item, array, index, index+n) ;

  assigns array[item_idx .. index+n-1],
          array[item_idx - 1]->next,
	  *list ;

  ensures GhostSeparation: \separated(list, array + (0 .. MAX_SIZE - 1)) ;
  ensures GhostSeparation: \separated(*list, array + (0 .. MAX_SIZE - 1)) ;

  ensures UnchangedItem: *item == \old(*item);

  behavior contains_item:
    assumes \exists integer i ; (index <= i < index+n) && array[i] == item ;
    ensures Linked: linked_n(*list, array, index, n-1, NULL);
    ensures ItemNotIn: \forall integer x ; index <= x < index+n-1 ==> array[x] != item ;
    ensures IttemSep: \forall integer x ; index <= x < index+n-1 ==> \separated(item, array[x]) ;
    ensures GhostSeparation: \separated(list, *(array + (index .. index + n - 2))) ;
    ensures Separation : 
      \forall integer y ; 
        index <= y < index + n - 1 ==> 
          \separated( * (array + y), array + (0 .. MAX_SIZE - 1));
    ensures Separation : 
      \forall integer y, z; 
        index <= y < index + n - 1 && index <= z < index + n - 1 && y != z ==> 
          \separated(* (array + y), * (array + z));
    ensures Unique:
      \forall integer y, z; 
        index <= y < index + n - 1 && index <= z < index + n - 1 && y != z ==> 
          array[y] != array[z];
    ensures Unchanged: unchanged{Pre,Post}(array, index, item_idx - 1);
    ensures Swiped: array_swipe_left{Pre,Post}(array, item_idx, index + n - 1);
    ensures PrevItem: item_idx > index ==> array[item_idx - 1] == \old(array[item_idx - 1]);
    ensures UnchangedSwipe: 
      \forall integer i ; item_idx <= i < index + n - 1 ==>
        \at(*array[i], Post) == \at(*array[i+1], Pre);

  behavior does_not_contain_item:
    assumes \forall integer i ; index <= i < index+n ==> array[i] != item ;
    ensures linked_n(*list, array, index, n, NULL);
    ensures \forall integer x ; index <= x < index+n ==> array[x] != item ;
    ensures \forall integer x ; index <= x < index+n ==> \separated(item, array[x]) ;
    ensures GhostSeparation: \separated(list, *(array + (index .. index + n - 1))) ;
    ensures Separation : 
      \forall integer y ; 
        index <= y < index + n ==> 
          \separated( * (array + y), array + (0 .. MAX_SIZE - 1));
    ensures Separation : 
      \forall integer y, z; 
        index <= y < index + n && index <= z < index + n && y != z ==> 
          \separated(* (array + y), * (array + z));
    ensures Unique:
      \forall integer y, z; 
        index <= y < index + n && index <= z < index + n && y != z ==> 
          array[y] != array[z];
    ensures unchanged{Pre, Post}(array, index, index + n);

  complete behaviors;
  disjoint behaviors;
*/
void
list_remove( list_t list, struct list *item,
	     /* ghost: */ struct list **array, int index, int n, int item_idx)
{
  if( *list == NULL ){
    return ;
  }
  if( *list == item ){
    //@ ghost array_pop(array, index, n, list, *list, NULL, index);

    //@ ghost struct list* lnext = (*list)->next ;

    //@ ghost R1: ;
    *list = (*list)->next ;

    
    return ;
  }

  struct list *r = *list ;
  int i = index ;
  /*@
    loop invariant index <= i <= index + n ;
    loop invariant linked_n(*list, array, index, (i - index), r) ;
    loop invariant linked_n(r, array, i, 1, r->next) ;
    loop invariant linked_n(r->next, array, i + 1, n - (i - index) - 1, NULL) ;
    loop invariant unchanged{Pre, Here}(array, index, i);
    loop invariant \forall integer j ; index <= j <= i ==> array[j] != item ;
    loop invariant \forall integer j ; index <= j < i ==> \separated(item, array[j]) ;
    loop assigns r, i ;
    loop variant n - (i - index) ;
   */
  while(r->next != item && r->next != NULL){
    
    r = r -> next ;
    ++i;
  }
  
  if( r->next == item ){
    
    
    //@ ghost BAP: ;
    //@ ghost array_pop(array, i+1, n - (i - index) - 1, list, r->next, NULL, index) ;

    //@ ghost if(i - index > 0) linked_n_split_segment(*list, r->next, array, index, i-index, r, 1) ;




    //@ ghost R2: ;
    r->next = r->next->next ;



 

    /*@ ghost 
        int gn = (i - index) ;
	int gk = n - (i - index) - 1 ;
    */

  } else {
  }
}

#endif
