#ifdef _IN_LIST_MAIN_FILE

/*@
  requires \valid(list);
  requires ValidArray : \valid( array + (0 .. MAX_SIZE - 1) );
  requires linked_n(*list, array, index, n, NULL);
  assigns \nothing ;

  behavior empty:
    assumes *list == NULL;
    ensures \result == NULL;

  behavior not_empty:
    assumes *list != NULL;
    ensures \result == array[index+n-1];
    ensures \result != NULL;
    ensures linked_n(*list, array, index, n-1, \result);
  
  complete behaviors;
  disjoint behaviors;
 */
struct list *
list_tail(   list_t list,
/* ghost: */ struct list **array, int index, int n)
{
  struct list *l;
  
  if(*list == NULL) {
    return NULL;
  }
  l = *list ;
  //@ ghost int i = 0 ;
  /*@
    loop invariant 0 <= i < n ;
    loop invariant l == array[index+i];
    loop invariant linked_n(*list, array, index, i, l);
    loop invariant linked_n(l, array, index + i, n - i, NULL);
    loop assigns l, i;
    loop variant (n - 1) - i;
  */
  while(l->next != NULL){
    l = l->next ;
    //@ ghost i++;
  }
  
  return l;
}

#endif
