/*@
  ensures unchanged{Pre,Here}(array, index, index + n);
  assigns array[index + n] ;
*/
void x(struct list** array, int index, int n);

/*@
  requires n >= 0 ;
  requires ValidArray : \valid( array + (0 .. MAX_SIZE - 1) );
  requires linked_n (root, array, index, n, bound);
  assigns array[index + n] ;
  ensures linked_n (root, array, index, n, bound); 
*/
void f(struct list* root, struct list** array, int index, int n, struct list* bound){

  x(array, index, n);
  
  if(n != 0){
    struct list* c = bound ;
    /*@
      loop invariant 0 <= i <= n ;
      loop invariant linked_n{Pre}(c, array, index+i, n - i, bound) ;
      loop invariant linked_n{Here}(c, array, index+i, n - i, bound) ;
      loop assigns i, c ;
      loop variant i ;	
    */
    for(int i = n ; i > 0 ; --i){
      c = array[index + i - 1] ;
    }
  }
}
