/*@
  predicate separated_list(list_t list, struct list **array, integer index, integer n) =
    \separated(list, array + (0 .. MAX_SIZE - 1)) &&
    \separated(list, *(array + (index .. index + n - 1))) &&
    \separated(*list, array + (0 .. MAX_SIZE - 1)) ;
*/
/*@
  predicate cells_separation(struct list** array, integer index, integer n) =
    (\forall integer y ; index <= y < index + n ==> 
      \separated( * (array + y), array + (0 .. MAX_SIZE - 1))) &&
    (\forall integer y, z; index <= y < index + n && index <= z < index + n && y != z ==> 
        \separated( * (array + y), * (array + z) )) &&
    (\forall integer y, z; index <= y < index + n && index <= z < index + n && y != z ==> 
        array[y] != array[z]);
*/

/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  // requires TEST: separated_list(list, array, 0, 0); // <<< removed separation

  ensures TEST:  separated_list(list, array, 0, 0);
  ensures TEST:  linked_n(*list, array, 0, 0, *list);
  ensures TEST:  *list == NULL;
*/
void fail_push_pop_empty(list_t list,
            /* ghost :*/ struct list** array)
{
  list_init(list, /*ghost*/ array); // <<< fails on precondition
  
  struct list l1 ;

  //@ ghost int pos_l1 = array_find(&l1, array, 0, 0);

  list_push(list, &l1, /*ghost*/ array, 0, 0, pos_l1);
  list_pop(list, /*ghost*/ array, 0, 1);
}

/*@
  // requires TEST: \valid(list) ; <<< removed list handler validity
  requires TEST: \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 0);

  ensures TEST:  separated_list(list, array, 0, 0);
  ensures TEST:  linked_n(*list, array, 0, 0, *list);
  ensures TEST:  *list == NULL;
*/
void fail_push_chop_empty(list_t list,
             /* ghost :*/ struct list** array)
{
  list_init(list, /*ghost*/ array); // <<< fails on precondition
  
  struct list l1 ;

  //@ ghost int pos_l1 = array_find(&l1, array, 0, 0);

  list_push(list, &l1, /*ghost*/ array, 0, 0, pos_l1);
  list_chop(list, /*ghost*/ array, 0, 1);
}

/*@
  requires TEST: \valid(list) ;
  // requires TEST: \valid( array + (0 .. MAX_SIZE - 1) ); <<< removed companion array validity
  requires TEST: separated_list(list, array, 0, 0);

  ensures TEST:  separated_list(list, array, 0, 0);
  ensures TEST:  linked_n(*list, array, 0, 0, *list);
  ensures TEST:  *list == NULL;
*/
void fail_push_remove_empty(list_t list,
       /* ghost :*/ struct list** array)
{ 
  list_init(list, /*ghost*/ array); // <<< fails on precondition
  
  struct list l1 ;

  //@ ghost int pos_l1 = array_find(&l1, array, 0, 0);

  list_push(list, &l1, /*ghost*/ array, 0, 0, pos_l1);

  //@ ghost pos_l1 = array_find(&l1, array, 0, 0);
  
  list_remove(list, &l1, /*ghost*/ array, 0, 1, pos_l1);
}

/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 0);

  ensures TEST:  separated_list(list, array, 0, 0);
  ensures TEST:  linked_n(*list, array, 0, 0, *list);
  ensures TEST:  *list == NULL;
*/
void fail_add_pop_empty(list_t list,
       /* ghost :*/ struct list** array)
{
  list_init(list, /*ghost*/ array);
  
  struct list l1 ;

  //@ ghost int pos_l1 = array_find(&l1, array, 0, 0);

  //                              Mistake with size
  //                                      v
  list_add(list, &l1, /*ghost*/ array, 0, 1, pos_l1); // <<< fails on precondition
  list_pop(list, /*ghost*/ array, 0, 1);
}

/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 0);

  ensures TEST:  separated_list(list, array, 0, 0);
  ensures TEST:  linked_n(*list, array, 0, 0, *list);
  ensures TEST:  *list == NULL;
*/
void fail_add_chop_empty(list_t list,
       /* ghost :*/ struct list** array)
{
  list_init(list, /*ghost*/ array);
  
  struct list l1 ;

  //@ ghost int pos_l1 = array_find(&l1, array, 0, 0);

  list_add(list, &l1, /*ghost*/ array, 0, 0, pos_l1);

  //                      Wrong starting point
  //                               v
  list_chop(list, /*ghost*/ array, 1, 1); // <<< fails on precondition
}

/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 0);

  //                                     Wrong size after
  //                                            v
  ensures TEST:  separated_list(list, array, 0, 1); // <<< fails on post-condition
  //                                       v
  ensures TEST:  linked_n(*list, array, 0, 1, *list); // <<< fails on post-condition
  ensures TEST:  *list == NULL;
*/
void fail_add_remove_empty(list_t list,
       /* ghost :*/ struct list** array)
{
  list_init(list, /*ghost*/ array);
  
  struct list l1 ;

  //@ ghost int pos_l1 = array_find(&l1, array, 0, 0);

  list_add(list, &l1, /*ghost*/ array, 0, 0, pos_l1);

  //@ ghost pos_l1 = array_find(&l1, array, 0, 0);
  
  list_remove(list, &l1, /*ghost*/ array, 0, 1, pos_l1);
}

/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 0);

  requires TEST: \valid(l1) && \separated(l1, list);
  requires TEST: \separated(l1, array + (0 .. MAX_SIZE-1));

  ensures TEST:  separated_list(list, array, 0, 1);

  //                            Wrong index after
  //                                    v
  ensures TEST:  linked_n(*list, array, 1, 1, NULL); // <<< fails on post-condition
  ensures TEST:  array[0] == l1 ;
*/
void fail_push_push_pop(list_t list, struct list* l1,
       /* ghost :*/ struct list** array)
{
  list_init(list, /*ghost*/ array);
  
  struct list l2 ;

  //@ ghost int pos_l1 = array_find(l1, array, 0, 0);

  list_push(list, l1, /*ghost*/ array, 0, 0, pos_l1);
  
  //@ ghost int pos_l2 = array_find(&l2, array, 0, 1);
  
  list_push(list, &l2 , /*ghost*/ array, 0, 1, pos_l2);
  list_pop(list, /*ghost*/ array, 0, 2);
}

/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 0);

  requires TEST: \valid(l1) && \separated(l1, list);
  // requires TEST: \separated(l1, array + (0 .. MAX_SIZE-1)); <<< removed l1 separation

  ensures TEST:  separated_list(list, array, 0, 1);
  ensures TEST:  linked_n(*list, array, 0, 1, NULL);
  ensures TEST:  array[0] == l1 ;
*/
void fail_push_push_chop(list_t list, struct list* l1,
       /* ghost :*/ struct list** array)
{
  list_init(list, /*ghost*/ array);
  
  struct list l2 ;

  //@ ghost int pos_l2 = array_find(&l2, array, 0, 0);

  list_push(list, &l2, /*ghost*/ array, 0, 0, pos_l2);
  
  //@ ghost int pos_l1 = array_find(l1, array, 0, 1);
  
  list_push(list, l1 , /*ghost*/ array, 0, 1, pos_l1); // <<< fails on precondition
  list_chop(list, /*ghost*/ array, 0, 2);
}

/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 1);
  requires TEST: cells_separation(array, 0, 1);
  requires TEST: linked_n(*list, array, 0, 1, NULL);

  requires TEST: \valid(l1) && \separated(l1, list);
  requires TEST: \separated(l1, array + (0 .. MAX_SIZE-1));
  requires TEST: l1 != array[0] && \separated(l1, array[0]);

  requires TEST: \valid(l3) && \separated(l3, list);
  requires TEST: \separated(l3, array + (0 .. MAX_SIZE-1));
  requires TEST: l3 != array[0] && \separated(l3, array[0]);
  
  // requires TEST: l1 != l3 && \separated(l1, l3); // <<< removed separation of items

  // None of these postconditions can be verified
  ensures TEST:  separated_list(list, array, 0, 3);
  ensures TEST:  cells_separation(array, 0, 3);
  ensures TEST:  linked_n(*list, array, 0, 3, NULL);
  ensures TEST:  array[0] == l1;
  ensures TEST:  array[1] == \old(array[0]);
  ensures TEST:  array[2] == l3;
*/
void fail_push_add_on_single(list_t list, struct list *l1, struct list *l3,
	   /* ghost :*/ struct list** array)
{
  //@ ghost int pos_l1 = array_find(l1, array, 0, 1);

  list_push(list, l1, /*ghost*/ array, 0, 1, pos_l1);

  //@ ghost int pos_l3 = array_find(l3, array, 0, 2);

  // quite subtle fail on precondition :
  //  we are not sure that l1 and l3 are different but they could, and in this
  //  case we do not know that they are separated. Since l1 is now in the list
  //  the separation of item in case of different element fails.
  list_add(list, l3, /*ghost*/ array, 0, 2, pos_l3); 
}

/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 1);
  requires TEST: cells_separation(array, 0, 1);
  requires TEST: linked_n(*list, array, 0, 1, NULL);

  requires TEST: \valid(l1) && \separated(l1, list);
  requires TEST: \separated(l1, array + (0 .. MAX_SIZE-1));
  requires TEST: l1 != array[0] && \separated(l1, array[0]);

  requires TEST: \valid(l3) && \separated(l3, list);
  requires TEST: \separated(l3, array + (0 .. MAX_SIZE-1));
  requires TEST: l3 != array[0] && \separated(l3, array[0]);
  
  requires TEST: l1 != l3 && \separated(l1, l3);

  ensures TEST:  separated_list(list, array, 0, 3);
  ensures TEST:  cells_separation(array, 0, 3);
  ensures TEST:  linked_n(*list, array, 0, 3, NULL);

  // ensures TEST:  array[0] == l1;
  // ensures TEST:  array[1] == \old(array[0]);

  ensures TEST:  array[0] == \old(array[0]); // <<< Bad copy and paste, we thought
  ensures TEST:  array[1] == l1;             // <<< we made add and then add again
  ensures TEST:  array[2] == l3;
*/
void fail_add_push_on_single(list_t list, struct list *l1, struct list *l3,
	   /* ghost :*/ struct list** array)
{
  //@ ghost int pos_l3 = array_find(l3, array, 0, 1);

  list_add(list, l3, /*ghost*/ array, 0, 1, pos_l3);

  
  //@ ghost int pos_l1 = array_find(l1, array, 0, 2);

  list_push(list, l1, /*ghost*/ array, 0, 2, pos_l1);
}


/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 1);
  requires TEST: cells_separation(array, 0, 1);
  requires TEST: linked_n(*list, array, 0, 1, NULL);

  requires TEST: \valid(l1) && \separated(l1, list);
  requires TEST: \separated(l1, array + (0 .. MAX_SIZE-1));
  requires TEST: l1 != array[0] && \separated(l1, array[0]);

  ensures TEST:  separated_list(list, array, 0, 1);
  ensures TEST:  cells_separation(array, 0, 1);
  ensures TEST:  linked_n(*list, array, 0, 1, NULL);
  
  // We thought the idea was to remove the pushed element
  //                          v
  ensures TEST:  array[0] == \old(array[0]);
*/
void fail_push_remove_on_single(list_t list, struct list *l1, struct list *l3,
	   /* ghost :*/ struct list** array)
{
  struct list* root = *list ;
  
  //@ ghost int pos_l1 = array_find(l1, array, 0, 1);

  list_push(list, l1, /*ghost*/ array, 0, 1, pos_l1);

  //@ ghost int pos_root = array_find(root, array, 0, 2);
  
  list_remove(list, root, /*ghost*/ array, 0, 2, pos_root);
}


/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 0);

  requires TEST: \valid(l1) && \separated(l1, list);
  requires TEST: \separated(l1, array + (0 .. MAX_SIZE-1));

  requires TEST: \valid(l2) && \separated(l2, list);
  requires TEST: \separated(l2, array + (0 .. MAX_SIZE-1));

  requires TEST: \valid(l3) && \separated(l3, list);
  requires TEST: \separated(l3, array + (0 .. MAX_SIZE-1));
  
  requires TEST: l1 != l2 && l2 != l3 && l1 != l3 && \separated(l1, l2, l3);

  ensures TEST:  separated_list(list, array, 0, 2);
  ensures TEST:  cells_separation(array, 0, 2);
  ensures TEST:  linked_n(*list, array, 0, 2, NULL);
  ensures TEST:  array[0] == l1;
  ensures TEST:  array[1] == l3;
*/
void fail_push_add_add_remove(list_t list, struct list *l1, struct list* l2, struct list *l3,
	   /* ghost :*/ struct list** array)
{
  list_init(list, /*ghost*/ array);

  //@ ghost int pos_l1 = array_find(l1, array, 0, 0);

  list_push(list, l1, /*ghost*/ array, 0, 0, pos_l1);

  //@ ghost int pos_l2 = array_find(l2, array, 0, 1);

  list_add(list, l2, /*ghost*/ array, 0, 1, pos_l2);

  //                                  Forgot to update the size
  //                                              v
  //@ ghost int pos_l3 = array_find(l3, array, 0, 1);

  list_add(list, l3, /*ghost*/ array, 0, 2, pos_l3); // <<< fails on precondition

  //@ ghost pos_l2 = array_find(l2, array, 0, 3);

  list_remove(list, l2, /*ghost*/ array, 0, 3, pos_l2);
}

/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 0);

  requires TEST: \valid(l1) && \separated(l1, list);
  requires TEST: \separated(l1, array + (0 .. MAX_SIZE-1));

  requires TEST: \valid(l2) && \separated(l2, list);
  requires TEST: \separated(l2, array + (0 .. MAX_SIZE-1));

  requires TEST: \valid(l3) && \separated(l3, list);
  requires TEST: \separated(l3, array + (0 .. MAX_SIZE-1));
  
  requires TEST: l1 != l2 && l2 != l3 && l1 != l3 && \separated(l1, l2, l3);

  ensures TEST:  separated_list(list, array, 0, 2);
  ensures TEST:  cells_separation(array, 0, 2);
  ensures TEST:  linked_n(*list, array, 0, 2, NULL);
  ensures TEST:  array[0] == l1;
  ensures TEST:  array[1] == l3;
*/
void fail_push_add_remove_add(list_t list, struct list *l1, struct list* l2, struct list *l3,
	   /* ghost :*/ struct list** array)
{
  list_init(list, /*ghost*/ array);

  //@ ghost int pos_l1 = array_find(l1, array, 0, 0);

  list_push(list, l1, /*ghost*/ array, 0, 0, pos_l1);

  //@ ghost int pos_l2 = array_find(l2, array, 0, 1);

  list_add(list, l2, /*ghost*/ array, 0, 1, pos_l2);

  //@ ghost pos_l2 = array_find(l2, array, 0, 2);

  list_remove(list, l2, /*ghost*/ array, 0, 2, pos_l2);

  //                                  Forgot to update the size
  //                                              v  
  //@ ghost int pos_l3 = array_find(l3, array, 0, 2);

  list_add(list, l3, /*ghost*/ array, 0, 1, pos_l3); // <<< fails on precondition
}

/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 1);
  requires TEST: cells_separation(array, 0, 1);
  requires TEST: linked_n(*list, array, 0, 1, NULL);

  requires TEST: \valid(l1) && \separated(l1, list);
  requires TEST: \separated(l1, array + (0 .. MAX_SIZE-1));
  requires TEST: l1 != array[0] && \separated(l1, array[0]);

  ensures TEST:  separated_list(list, array, 0, 2);
  ensures TEST:  cells_separation(array, 0, 2);
  ensures TEST:  linked_n(*list, array, 0, 2, NULL);
  ensures TEST:  array[0] == \old(array[0]);
  ensures TEST:  array[1] == l1;
*/
void fail_push_add_same_single(list_t list, struct list *l1,
	   /* ghost :*/ struct list** array)
{
  //@ ghost int pos_l1 = array_find(l1, array, 0, 1);

  list_push(list, l1, /*ghost*/ array, 0, 1, pos_l1);

  // Forgot to updated the new position of l1
  // @ ghost pos_l1 = array_find(l1, array, 0, 2);

  list_add(list, l1, /*ghost*/ array, 0, 2, pos_l1); // <<< fails on precondition
}

/*@
  requires TEST: \valid(list) && \valid( array + (0 .. MAX_SIZE - 1) );
  requires TEST: separated_list(list, array, 0, 1);
  requires TEST: cells_separation(array, 0, 1);
  requires TEST: linked_n(*list, array, 0, 1, NULL);

  requires TEST: \valid(l1) && \separated(l1, list);
  requires TEST: \separated(l1, array + (0 .. MAX_SIZE-1));
  requires TEST: l1 != array[0] && \separated(l1, array[0]);

  ensures TEST:  separated_list(list, array, 0, 2);
  ensures TEST:  cells_separation(array, 0, 2);
  ensures TEST:  linked_n(*list, array, 0, 2, NULL);

  // ensures TEST:  array[0] == l1;
  // ensures TEST:  array[1] == \old(array[0]);

  // Inverted values
  ensures TEST:  array[0] == \old(array[0]);
  ensures TEST:  array[1] == l1;
*/
void fail_add_push_same_single(list_t list, struct list *l1,
	   /* ghost :*/ struct list** array)
{
  //@ ghost int pos_l1 = array_find(l1, array, 0, 1);

  list_add(list, l1, /*ghost*/ array, 0, 1, pos_l1);

  //@ ghost pos_l1 = array_find(l1, array, 0, 2);

  list_push(list, l1, /*ghost*/ array, 0, 2, pos_l1);
}
