/*@ ensures  occ_a(e, t, from, to) >= 0; 
  @ assigns \nothing;
  @*/
void occ_a_positive(int e, char *t, int from, int to)
{
  if(from <= to){
    /*@ loop invariant from<=i<=to;
      @ loop invariant occ_a(e,t,from,i) >= 0;
      @ loop assigns i;
      @ loop variant to - i; */
    for(int i = from; i<to; i++);
  }
}

/*@ requires from <= to;
  @ ensures  occ_a(e, t, from, to) <= to - from; 
  @ assigns \nothing;
  @*/
void occ_a_bounded(int e, char *t, int from, int to)
{
  /*@ loop invariant from<=i<=to;
    @ loop invariant occ_a(e,t,i,to) <= to - i;
    @ loop assigns i;
    @ loop variant i - from; */
  for(int i = to; from<i; i--){
  }
}

/*@ requires not_in(e, t, from, to); 
  @ ensures  occ_a(e, t, from, to) == 0; 
  @ assigns \nothing;
  @*/
void not_in_means_0_occ_a(int e, char *t, int from, int to)
{
  if(from <= to){
    /*@ loop invariant from<=i<=to;
      @ loop invariant occ_a(e,t,i,to) == 0;
      @ loop assigns i;
      @ loop variant i - from; */
    for(int i = to; from<i; i--){
      }
  }
}

/*@ requires occ_a(e, t, from, to) == 0; 
  @ ensures  not_in(e, t, from, to); 
  @ assigns \nothing;
  @*/
void zero_occ_a_means_not_in(int e, char *t, int from, int to)
{
  if(from <= to){
    int i = from;
    /*@ loop invariant from<=i<=to;
      @ loop invariant occ_a(e, t, from, i) == 0; 
      @ loop invariant not_in(e,t,from,i);
      @ loop assigns i;
      @ loop variant to - i; */
    while(i<to){
      i++;
    }
  }
}

/*@ requires from <= to;
  @ requires everywhere(e, t, from, to);
  @ ensures occ_a(e, t, from, to) == to - from;
  @ assigns \nothing;
  @*/
void everywhere_means_all_occ_a(int e, char *t, int from, int to)
{
  if(from <= to){
    /*@ loop invariant from<=i<=to;
      @ loop invariant occ_a(e, t, i, to) == to - i;
      @ loop assigns i;
      @ loop variant i - from ;
      @ */
    for(int i = to; from < i; i--){
      }
  }
}

/*@ requires from <= cut <= to;
  @ requires occ_a(e, t, from, to) == to - from;
  @ ensures occ_a(e, t, cut, to) == to - cut; 
  @ ensures occ_a(e, t, from, cut) == cut - from; 
  @ assigns \nothing;
*/
void aux(int e, char *t, int from, int cut, int to){
  /*@ loop invariant cut<=i<=to;
    @ loop invariant occ_a(e, t, i, to) == to - i;
    @ loop invariant occ_a(e, t, from, i) == i - from;
    @ loop assigns i;
    @ loop variant i - cut;
    @ */
  for(int i = to; cut<i; i--){
    //@ ghost occ_a_bounded(e, t, from, i-1);
  }
}


/*@ requires from <= to;
  @ requires occ_a(e, t, from, to) == to - from;
  @ ensures everywhere(e, t, from, to);
  @ assigns \nothing;
  @*/
void all_occ_a_means_everywhere(int e, char *t, int from, int to){
  if(from<=to){
    /*@ loop invariant from<=i<=to;
      @ loop invariant everywhere(e, t, i, to);
      @ loop invariant occ_a(e, t, i, to) == to - i;
      @ loop invariant occ_a(e, t, from, i) == i - from;
      @ loop assigns i;
      @ loop variant i - from; 
      @*/
    for(int i = to; from<i; i--){
      //@ ghost aux(e, t, from, i-1, to);
	// @ ghost occ_a_split(e, t, i-1, i, to);
	// @ ghost occ_a_bounded(e, t, i-1, i);
	// @ ghost occ_a_positive(e, t, from, i);
      }
  }
}

/*@ requires valid_memb(m);
  @ requires m->num >= 0;
  @ requires _memb_empty(m);
  @ ensures _memb_numfree(m) == m->num; */
void _memb_empty_numfree(struct memb *m){
  //@ ghost everywhere_means_all_occ_a(0, m->count, 0, m->num);
}

/*@ requires valid_memb(m);
  @ requires _memb_numfree(m) == m->num;
  @ ensures _memb_empty(m); */
void _memb_numfree_empty(struct memb *m){
  //@ ghost all_occ_a_means_everywhere(0, m->count, 0, m->num);
}

/*@ requires valid_memb(m);
  @ requires _memb_full(m);
  @ ensures _memb_numfree(m) == 0; */
void _memb_full_numfree(struct memb *m){
  //@ ghost not_in_means_0_occ_a(0, m->count, 0, m->num);
}


/*@ requires valid_memb(m);
  @ requires _memb_numfree(m) == 0; 
  @ ensures _memb_full(m); */
void _memb_numfree_full(struct memb *m){
  //@ ghost zero_occ_a_means_not_in(0, m->count, 0, m->num);
}
