#!/bin/bash

if [ ! -f "README.md" ]; then
    echo "Error: the working directory must be the home of NTP4Verif"
    exit 1
fi

first_line=$(head -n 1 README.md)
if [ "$first_line" != "# NTP4Verif" ]; then
    echo "Error: the working directory must be the home of NTP4Verif"
    exit 1
fi

find ./generation -type f -writable -delete
find data/why3 -name "*.xml" -type f -delete
find data/why3 -name "*.yaml" -type f -delete
find data/why3/pearl -name "*.lean" -type f ! -path data/why3/pearl/Benchmark.lean -delete
find data/why3/frama_c -name "*.lean" -type f ! -path data/why3/frama_c/Benchmark.lean -delete
find data/why3 -name "*.thy" -type f -delete
find data/why3 -name "*.v" -type f -delete
find data/why3 -name "ROOT" -type f -delete
find data/why3 -name "theories.lst" -type f -delete
find data/why3 -name "dep_sessions.lst" -type f -delete
find data/why3 -name "dune" -type f -delete
rm ./.cache -rv
mkdir -p ./generation/isabelle/meta/why3/BuiltIn
rm .VCG.cache .lean.cache .rocq.cache -f

dune clean || true

git checkout -- data/why3/pearl/defunctionalization_vcg/isabelle/defunctionalization_SemWithError.thy data/why3/pearl/fibonacci_vcg/isabelle/fibonacci_Mat22.thy data/why3/pearl/fibonacci_vcg/isabelle/fibonacci/Mat22.xml data/why3/pearl/fibonacci_vcg/isabelle/fibonacci/Mat22.yaml generation/isabelle/mach/c_C.thy generation/isabelle/mach/c_UChar.thy generation/lean/Why3/mach/c/UChar.lean generation/isabelle/meta/mach/c/C.yaml generation/isabelle/meta/mach/c/UChar.yaml generation/lean/meta/mach/c/UChar.yaml data/why3/pearl/defunctionalization_vcg/isabelle/defunctionalization/SemWithError.yaml generation/rocq/meta/mach/c/UChar.yaml generation/rocq/Why3/mach/c/UChar.v

chmod 444 data/why3/pearl/defunctionalization_vcg/isabelle/defunctionalization_SemWithError.thy data/why3/pearl/fibonacci_vcg/isabelle/fibonacci_Mat22.thy data/why3/pearl/fibonacci_vcg/isabelle/fibonacci/Mat22.xml data/why3/pearl/fibonacci_vcg/isabelle/fibonacci/Mat22.yaml generation/isabelle/mach/c_C.thy generation/isabelle/mach/c_UChar.thy generation/lean/Why3/mach/c/UChar.lean generation/isabelle/meta/mach/c/C.yaml generation/isabelle/meta/mach/c/UChar.yaml generation/lean/meta/mach/c/UChar.yaml data/why3/pearl/defunctionalization_vcg/isabelle/defunctionalization/SemWithError.yaml generation/rocq/meta/mach/c/UChar.yaml generation/rocq/Why3/mach/c/UChar.v


#ln -s ../../../../../lib/Isabelle/NTP4Verif/BuiltIn.yaml ./generation/isabelle/meta/why3/BuiltIn/BuiltIn.yaml
